<?php if ( !defined( 'ABSPATH' ) ) exit;

/*

	Template Name: Categories

	1 - RETRIEVE DATA

	2 - PAGE

		2.1 - Default content
		2.2 - Categories

*/

/*===============================================

	R E T R I E V E   D A T A
	Get a required page data

===============================================*/

	global
		$st_Settings;

		$st_ = array();

		// Is title disabled?
		$st_['title_disabled'] = st_get_post_meta( $post->ID, 'disable_title_value', true, 0 );

		// Is breadcrumbs disabled?
		$st_['breadcrumbs_disabled'] = st_get_post_meta( $post->ID, 'disable_breadcrumbs_value', true, 0 );

		// Subtitle
		$st_['subtitle'] = get_post_meta( $post->ID, 'subtitle_value', true );

		// Get custom sidebar
		$st_['sidebar'] = st_get_post_meta( $post->ID, 'sidebar_value', true, 'default-sidebar' );

		// Get sidebar position
		$st_['sidebar_position'] = 'none';

			// Re-define global $content_width if sidebar not exists
			if ( $st_['sidebar_position'] == 'none' ) {
				$content_width = $st_Options['global']['images']['st-large']['width']; }
			else {
				$content_width = $st_Options['global']['images']['st-archive-image']['width']; }

		// Counter
		$st_['count'] = 0;

		// Arguments
		$st_['args'] = array(
			'type'			=> 'post',
			'child_of'		=> 0,
			'parent'		=> '',
			'orderby'		=> 'count',
			'order'			=> 'DESC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 1,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> 'category',
			'pad_counts'	=> false 
		);

		// Get categories
		$st_['categories'] = get_categories( $st_['args'] );



/*===============================================

	P A G E
	Display a required page

===============================================*/

	get_header();

		?>

			<div id="content-holder" class="sidebar-position-<?php echo esc_attr( $st_['sidebar_position'] ); ?>">

				<div id="content-box">
		
					<div>

						<div>

							<div class="v2 categories-t6">

								<?php
	
	
									/*-------------------------------------------
										2.1 - Default content
									-------------------------------------------*/
	
									if ( have_posts() ) {
				
										while ( have_posts() ) : the_post();
	
											if ( !$st_['title_disabled'] || get_the_content() ) {
	
												// Title
												if ( !$st_['title_disabled'] && !is_front_page() ) {
													echo '<h1 class="entry-title page-title">' . esc_attr( get_the_title() ) . ( $st_['subtitle'] ? ' <span class="title-sub">' . esc_attr( $st_['subtitle'] ) . '</span>' : '' ) . '</h1>'; }
	
												// Content
												if ( get_the_content() ) {
													echo '<article><div id="article">'; the_content(); echo '</div></article>'; }
			
												echo '<div class="clear"><!-- --></div>';
	
											}
	
										endwhile;
				
									}
	
	
									/*-------------------------------------------
										2.2 - Categories
									-------------------------------------------*/
	
									foreach ( $st_['categories'] as $st_['cat'] ) {
	
										$st_['count']++;
	
										include( get_template_directory() . '/includes/categories/t6.php' );
	
									}
	
	
	
								?>

							</div>

							<div class="clear"><!-- --></div>

						</div>

					</div>
		
				</div><!-- #content-box -->

				<div class="clear"><!-- --></div>

			</div><!-- #content-holder -->
	
		<?php

	get_footer();

?>