<?php if ( !defined( 'ABSPATH' ) ) exit;

/*

	1 - RETRIEVE DATA

		- Set views
		- Get post type names
		- Get post format
		- Is title disabled?
		- Is breadcrumbs disabled?
		- Get custom sidebar
		- Get sidebar position

	2 - POST

		2.2 - Article
			- Title
			- Below title data
			- Excerpt
			- Featured image
			- Before post data
			- Content
		2.3 - Pagination
		2.4 - Prev/Next post
		2.5 - Related posts
		2.6 - Comments
		2.7 - Post meta
			- Author info
			- Post short info
		2.8 - Post sidebar
		2.9 - Sidebar

*/

/*===============================================

	R E T R I E V E   D A T A
	Get a required post data

===============================================*/

	global
		$st_Options,
		$st_Settings;
	
		$st_ = array();

		// Post type names
		$st_['st_post'] = !empty( $st_Settings['ctp_post'] ) ? $st_Settings['ctp_post'] : $st_Options['ctp']['post'];

		// Post format
		$st_['format'] = get_post_format( $post->ID ) ? get_post_format( $post->ID ) : 'standard';

		// Feat image
		if ( !empty( $st_Settings['post_feat_image'] ) == 'yes' && has_post_thumbnail() ) {
	
			$st_['id'] = get_post_thumbnail_id( $post->ID );
			$st_['thumb'] = wp_get_attachment_image_src( $st_['id'], 'st-large' );
			$st_['thumb'] = $st_['thumb'][0];
			$st_['is_thumb'] = true;

		}

		// Does title disabled?
		$st_['title_disabled'] = st_get_post_meta( $post->ID, 'disable_title_value', true, 0 );
	
		// Does breadcrumbs disabled?
		$st_['breadcrumbs_disabled'] = st_get_post_meta( $post->ID, 'disable_breadcrumbs_value', true, 0 );

		// Does the post sidebar enabled?
		$st_['is_sidebar_post'] = is_active_sidebar( 'post-sidebar' ) ? ' post-sidebar-active' : ' post-sidebar-inactive';
	
		// Get custom sidebar
		$st_['sidebar'] = st_get_post_meta( $post->ID, 'sidebar_value', true, 'default-sidebar' );

		// Get sidebar position
		$st_['sidebar_position'] = st_get_post_meta( $post->ID, 'sidebar_position_value', true, 'right' );

			// Re-define global $content_width depends of sidebars
			if ( $st_['sidebar_position'] == 'none' ) {
				$content_width = $st_Options['global']['images']['st-large']['width']; }
			else {
				if ( is_active_sidebar( 'post-sidebar' ) ) {
					$content_width = $st_Options['global']['images']['st-post-image']['width'];
				}
				else {
					$content_width = $st_Options['global']['images']['st-archive-image']['width'];
				}
			}

		// Post sidebar sticky
		$st_['sidebar_post_sticky'] = !empty( $st_Settings['sidebar_post_sticky'] ) ? ' st-sticky' : '';

		// Counter
		$st_['count'] = 0;


/*===============================================

	P O S T
	Display a required post

===============================================*/

	get_header();

		?>

			<div id="content-holder" class="sidebar-position-<?php echo esc_attr( $st_['sidebar_position'] ) . $st_['is_sidebar_post']; ?>">

				<div id="post-title"<?php echo !empty( $st_['is_thumb'] ) == true ? ' class="post-title-with-img" ' . ( $st_['is_thumb'] == true && function_exists( 'st_get_2x' ) ? st_get_2x( $post->ID, 'st-large', 'attr' ) : '' ) . ' style="background-image: url(' . esc_url( $st_['thumb'] ) . ')"' : ''; ?>>

					<div class="x">

						<?php
						
							/*-------------------------------------------
								2.2 - Title
							-------------------------------------------*/
							if ( !empty( $st_['title_disabled'] ) != 1 && get_the_title() ) {
		
								// Rating
								echo ( function_exists( 'wp_review_show_total' ) ? wp_review_show_total( false ) : '' ) . "\n";
		
								// Meta
								st_post_meta( false, false, true, false, false, false ); ?>

								<div class="clear"><!-- --></div>

								<header>
									<h1 class="entry-title post-title"><?php
							
										echo esc_attr( get_the_title() );
							
										$st_['subtitle'] = get_post_meta( $post->ID, 'subtitle_value', true );
							
										if ( $st_['subtitle'] ) {
											echo ' <em>' . esc_attr( $st_['subtitle'] ) . '</em>'; } ?>
							
									</h1>
								</header><?php
						
							}
						
						?>

					</div>

					<?php

						/*--- Below title data -----------------------------*/
					
						if ( is_single() && !empty( $st_Settings['after_title'] ) && $st_Settings['after_title'] == 'yes' ) {
							echo '<div id="title-after">' . do_shortcode( !function_exists('st_kit') || empty( $st_Settings['sanitization'] ) ? esc_attr( $st_Settings['after_title_data'] ) : $st_Settings['after_title_data'] ) . '</div>'; }

					?>

					<div class="clear"><!-- --></div>
				</div>

				<?php

					/*--- Author info -----------------------------*/	

					if ( !isset( $st_Settings['author_info'] ) || !empty( $st_Settings['author_info'] ) && $st_Settings['author_info'] == 'yes' ) {

						$st_['is_single_author_info'] = true;

						include( get_template_directory() . '/includes/posts/formats/status.php' );

						echo '<div class="clear"><!-- --></div>';

					}

					$st_['is_single_author_info'] = false;

				?>

				<div id="content-box">
		
					<div>
		
						<?php
	
							if ( have_posts() ) :

								while ( have_posts() ) : the_post(); ?>

									<div id="post-<?php the_ID(); ?>" <?php post_class( 'post-single' ) ?>><?php


										/*-------------------------------------------
											2.2 - Article
										-------------------------------------------*/ ?>
										
										<div id="article" class="<?php echo is_active_sidebar( 'post-sidebar' ) ? 'sidebar-post-enabled' : '' ?>" role="main">

											<article itemscope itemType="http://schema.org/BlogPosting"><?php

												// Post sidebar
												if ( is_active_sidebar( 'post-sidebar' ) ) {
	
													echo '<div role="complementary" class="sidebar-post' . $st_['sidebar_post_sticky'] . '" data-master="content-box"><div>';
	
														if ( function_exists('dynamic_sidebar') && dynamic_sidebar('Post Sidebar') );
	
													echo '</div></div><!-- .sidebar-post -->';
	
												}
	
												// Excerpt
												if ( is_single() && !empty( $st_Settings['excerpt'] ) && $st_Settings['excerpt'] == 'yes' && $post->post_excerpt ) {
													echo '<div class="clear"><!-- --></div><div id="post-excerpt">' . wpautop( !function_exists('st_kit') || empty( $st_Settings['sanitization'] ) ? esc_attr( $post->post_excerpt ) : $post->post_excerpt ) . '</div><div class="clear"><!-- --></div>'; }
	
												// Post format
												include( get_template_directory() . '/includes/posts/formats/' . $st_['format'] . '.php' );
	
												// Before post data
												if ( !empty( $st_Settings['before_post'] ) && $st_Settings['before_post'] == 'yes' ) {
													echo '<div id="post-before">' . do_shortcode( !function_exists('st_kit') || empty( $st_Settings['sanitization'] ) ? esc_attr( $st_Settings['before_post_data'] ) : $st_Settings['before_post_data'] ) . '</div>'; }
	
												the_content();

												echo '<div class="clear"><!-- --></div>';
	
	
												/*-------------------------------------------
													2.3 - Pagination
												-------------------------------------------*/
	
												if ( wp_link_pages( 'echo=0' ) ) {
	
													if ( function_exists('wp_pagenavi') ) {
														?><div id="wp-pagenavibox"><?php wp_pagenavi( array( 'type' => 'multipart' ) ); ?></div><?php } 
	
													else {
														echo '<div class="page-pagination">';
															wp_link_pages( array( 'before' => '<span>' . __( 'Pages', 'shockmag' ) . ':</span> ' ) );
														echo '</div>';
													 }
	
												}


												echo '<footer>';
	
	
													// After post data
													if ( !empty( $st_Settings['after_post'] ) && $st_Settings['after_post'] == 'yes' ) {
														echo '<div id="post-after">' . do_shortcode( !function_exists('st_kit') || empty( $st_Settings['sanitization'] ) ? esc_attr( $st_Settings['after_post_data'] ) : $st_Settings['after_post_data'] ) . '<div class="clear"><!-- --></div></div>'; }
	
	
													/*-------------------------------------------
														2.7 - Post meta
													-------------------------------------------*/
		
													if ( !isset( $st_Settings['post_meta'] ) || !empty( $st_Settings['post_meta'] ) && $st_Settings['post_meta'] == 'yes' ) {
		
		
														/*--- Social share -----------------------------*/	
		
														if ( function_exists( 'st_post_share' ) ) {
															echo st_post_share( array( 'id' => $post->ID, 'class' => 'tooltip-css', 'attribute' => 'data-title' ) );
														}	
		
		
														/*--- Post short info -----------------------------*/ ?>
		
														<div class="post-short-info">
		
															<?php st_post_meta( true, true, true, false, true, true ); ?>
		
														</div><?php
		
		
														/*-------------------------------------------
															2.7 - Breadcrumbs
														-------------------------------------------*/
		
														if ( $st_['breadcrumbs_disabled'] != 1 && !is_front_page() && function_exists( 'st_breadcrumbs' ) ) {
															st_breadcrumbs(); }
		
		
													}
		
		
													/*-------------------------------------------
														2.4 - Prev/Next post
													-------------------------------------------*/
		
													if ( get_post_type() == 'post' ) {
														echo st_prev_next_post(); }
	
	
												echo '</footer>';

												if ( function_exists('st_schema_org_article_itemscope') ) {
													echo st_schema_org_article_itemscope( false ); }

												if ( function_exists('st_schema_org_review_itemscope') ) {	
													echo st_schema_org_review_itemscope( false ); } ?>

											</article><?php


											/*-------------------------------------------
												2.6 - Comments
											-------------------------------------------*/

											echo '<div id="comments-wrapper">';

												comments_template();
												
											echo '</div>'; ?>


											<div class="clear"><!-- --></div>
										</div><!-- #article -->

									</div><!-- #post-% --><?php
		
								endwhile;

							else :
	
								echo '<h1>404</h1><p>' . __( 'Sorry, no posts matched your criteria.', 'shockmag' ) . '</p>';
						
							endif;
		
						?>
		
						<div class="clear"><!-- --></div>
		
					</div>

				</div><!-- #content-box -->

				<?php

					/*-------------------------------------------
						2.9 - Sidebar
					-------------------------------------------*/

					if ( !isset( $st_['sidebar_position'] ) || !empty( $st_['sidebar_position'] ) && $st_['sidebar_position'] != 'none' ) {
						get_sidebar(); }

				?>

				<div class="clear"><!-- --></div>

				<?php
				
					/*-------------------------------------------
						2.5 - Related posts
					-------------------------------------------*/
				
					if ( !empty( $st_Settings['related'] ) == 'yes' && function_exists( 'st_related_posts' ) ) {

						$st_['query'] = st_related_posts( 6, '', 'h6', 'st-project-thumb', '', false, true );

						if ( $st_['query']->post_count > 0 ) {

							$st_['limit'] = 0;
							if ( $st_['query']->post_count > 2 ) { $st_['limit'] = 3; }
							if ( $st_['query']->post_count > 5 ) { $st_['limit'] = 6; }

							if ( $st_['limit'] != 0 ) {

								echo '<div class="v2 posts-related-wrapper">';
	
									echo '<div class="posts-related-title"><h6>' . __( 'You Might Also Like', 'shockmag' ) . '</h6></div>';
	
									while ( $st_['query']->have_posts() ) : $st_['query']->the_post();
		
										if ( $st_['count'] == $st_['limit'] ) { break; }
	
										$st_['count']++;
		
										include( get_template_directory() . '/includes/posts/t6.php' );
		
									endwhile;
	
								echo '<div class="clear"><!-- --></div></div>';

							}

						}

					}
				
				?>

			</div><!-- #content-holder -->
	
		<?php

	get_footer();

?>