<?php if ( !defined( 'ABSPATH' ) ) exit;

/*

	1 - RETRIEVE DATA

	2 - PAGE

		2.1 - Breadcrumbs
		2.2 - Article
			- Title
			- Content
		2.3 - Pagination
		2.4 - Sidebar

*/

/*===============================================

	R E T R I E V E   D A T A
	Get a required data

===============================================*/

	global
		$st_Options,
		$st_Settings;

		$st_ = array();
		$st_['args'] = array();

		$st_['count'] = 0;

		// Template name
		$st_['t'] = !empty( $st_Settings['blog_template'] ) ? $st_Settings['blog_template'] : 'default';

		// Get sidebar position
		$st_['sidebar_position'] = 'right';

		// Re-define content width
		$content_width = $st_Options['global']['images']['st-archive-image']['width'];



/*===============================================

	P A G E
	Display a required page

===============================================*/

	get_header();

		?>

			<div id="content-holder" class="sidebar-position-<?php echo esc_attr( $st_['sidebar_position'] ); ?>">
		
				<div id="content-box">
		
					<div>

						<div>

							<?php

								echo '<div id="term"><div class="term-title"><h1>' . esc_attr( get_search_query() ) . ' <span class="title-sub">' . $wp_query->found_posts . '</span></h1></div></div>';

								if ( have_posts() ) :
	


									// No. of current page
									$st_['p'] = $paged > 1 ? $paged : 1;
	
									// Qty of posts per page 
									$st_['per_page'] = get_option( 'posts_per_page' );
	
									// No. of first post on current page
									$st_['start'] = ( $st_['p'] - 1 ) * $st_['per_page'] + 1;



									/*-------------------------------------------
										2.1 - Breadcrumbs
									-------------------------------------------*/

									echo '<div class="' . ( $st_['sidebar_position'] == 'none' && ( $st_['t'] == 't6' || $st_['t'] == 't10' || $st_['t'] == 't11' ) ? 'v2' : 'v1' ) . '">';


										while ( have_posts() ) : the_post();
		
											$st_['count']++;
		
											include( get_template_directory() . '/includes/posts/' . $st_['t'] . '.php' );
		
										endwhile;

		
										// Pagination
										if ( function_exists('wp_pagenavi') ) {
											?><div id="wp-pagenavibox"><?php wp_pagenavi(); ?></div><?php } 
										else {
											?><div id="but-prev-next"><?php next_posts_link( __( 'Older posts', 'shockmag' ) ); previous_posts_link( __( 'Newer posts', 'shockmag' ) ); ?></div><?php } 


									echo '</div>';



								else :



									echo '<p>' . __( 'Sorry, nothing matched your search criteria. Please try again with some different keywords.', 'shockmag' ) . '</p>';
									


								endif;
		
							?>
			
							<div class="clear"><!-- --></div>

						</div>

					</div>
		
				</div><!-- #content-box -->

				<?php

					/*-------------------------------------------
						2.4 - Sidebar
					-------------------------------------------*/

					get_sidebar();

				?>
	
				<div class="clear"><!-- --></div>

			</div><!-- #content-holder -->
	
		<?php

	get_footer();

?>