<?php if ( !defined( 'ABSPATH' ) ) exit;

/*

	- general
	- global
	- js
	- menu
	- sidebars
	- widgets
	- metaboxes
	- shortcodes
	- breadcrumbs
	- networks
	- networks_path
	- panel

*/

/*===============================================

	T H E M E   O P T I O N S
	Unique options of the theme

===============================================*/

	global
		$st_Options,
		$st_Settings;

	$st_Options = array (
	
		'general'		=>	array (
								'name'				=>	'shockmag_',
								'label'				=>	'Shockmag',
								'version'			=>	'1.0.6',
								'url'				=>	'http://strictthemes.com/theme/shockmag',
								'url-demo'			=>	'http://strictthemes.com/shockmag',
								'documentation'		=>	'http://strictthemes.com/shockmag/category/documentation',
								'developer'			=>	'StrictThemes',
								'developer-url'		=>	'http://strictthemes.com',
								'stkit-min'			=>	'1.8.3',
								),
		'global'		=>	array (
								'content_width'		=>	849,
								'rss'				=>	true,
								'lang'				=>	true,
								'rtl'				=>	false,
								'excerpt'			=>	25, // words
								'excerpt-in-search'	=>	true,
								'tag-cloud'			=>	13, // px
								'post-formats'		=>	array(
															'enabled'		=>	true,
															'post-title'	=>	true, // metabox option
															'aside'			=>	array(
																						'status'		=>	false,
																						'label'			=>	__( 'Aside', 'shockmag' ),
																					),
															'image'			=>	array(
																						'status'		=>	true,
																						'label'			=>	__( 'Image', 'shockmag' ),
																					),
															'gallery'		=>	array(
																						'status'		=>	true,
																						'label'			=>	__( 'Gallery', 'shockmag' ),
																					),
															'audio'			=>	array(
																						'status'		=>	true,
																						'label'			=>	__( 'Audio', 'shockmag' ),
																					),
															'video'			=>	array(
																						'status'		=>	true,
																						'label'			=>	__( 'Video', 'shockmag' ),
																					),
															'link'			=>	array(
																						'status'		=>	true,
																						'label'			=>	__( 'Link', 'shockmag' ),
																					),
															'quote'			=>	array(
																						'status'		=>	true,
																						'label'			=>	__( 'Quote', 'shockmag' ),
																					),
															'status'		=>	array(
																						'status'		=>	true,
																						'label'			=>	__( 'Status', 'shockmag' ),
																					),
															'chat'			=>	array(
																						'status'		=>	false,
																						'label'			=>	__( 'Chat', 'shockmag' ),
																					),
															),
								'images'			=>	array(
															'st-thumbnail'		=>	array(
																						'status'		=>	true,
																						'width'			=>	150,
																						'height'		=>	150,
																						'crop'			=>	true,
																						),
															'st-medium'			=>	array(
																						'status'		=>	false,
																						'width'			=>	300,
																						'height'		=>	300,
																						'crop'			=>	true,
																						),
															'st-large'			=>	array(
																						'status'		=>	true,
																						'width'			=>	1200,
																						'height'		=>	9999,
																						'crop'			=>	false,
																						),
															'st-archive-image'	=>	array(
																						'status'		=>	true,
																						'width'			=>	850,
																						'height'		=>	9999,
																						'crop'			=>	false,
																						),
															'st-post-image'		=>	array(
																						'status'		=>	true,
																						'width'			=>	640,
																						'height'		=>	9999,
																						'crop'			=>	false,
																						),
															'st-project-thumb'	=>	array(
																						'status'		=>	true,
																						'width'			=>	262,
																						'height'		=>	180,
																						'crop'			=>	true,
																						),
															'st-project-medium'	=>	array(
																						'status'		=>	true,
																						'width'			=>	574,
																						'height'		=>	408,
																						'crop'			=>	true,
																						),
															),
								'custom-background'	=>	true,
								'custom-header'		=>	false,
								'category-image'	=>	true,
								'category-sidebar'	=>	true,
								'title-tag'			=>	true,
								'st_the_content_article'		=>	false,
								'st_the_content_article_end'	=>	false,
								),
		'ctp'			=>	array (
								'query'			=>	'main', /* needed for action */
								'assets'		=>	'disabled',
								'qty'			=>	'12',
								'qty_another'	=>	'8',
								'post'			=>	'st_project',
								'category'		=>	'st_category',
								'tag'			=>	'st_tag',
								'ctp-formats'	=>	array(
														'enabled'		=>	true,
														'gallery'		=>	array(
																					'status'		=>	false,
																					'label'			=>	__( 'Gallery', 'shockmag' ),
																				),
														'audio'			=>	array(
																					'status'		=>	false,
																					'label'			=>	__( 'Audio', 'shockmag' ),
																				),
														'video'			=>	array(
																					'status'		=>	false,
																					'label'			=>	__( 'Video', 'shockmag' ),
																				),
														'bg-color'		=>	'disabled',
														'bg-image'		=>	'disabled',
														'formats'		=>	array(
																					'tag'			=>	'st_format',
																					'slug'			=>	'only',
																				),
														),
								),
		'js'			=>	array (
								'st'			=>	true,
								'menu'			=>	false,
								'theme'			=>	false,
								'prettyPhoto'	=>	false,
								'picbox'		=>	true,
								'mediaelement'	=>	true,
								'owl'			=>	true,
								),
		'menu'			=>	array (
								'primary'		=>	true,
								'secondary'		=>	true,
								),
		'sidebars'		=>	array (
								'default'		=>	true,
								'secondary'		=>	false,
								'post-sidebar'	=>	true,
								'homepage'		=>	false,
								'ads'			=>	array(
														__( 'Appears on the header of all pages.', 'shockmag' ),
														__( 'Appears on the middle of homepage and archives.', 'shockmag' ),
														__( 'Appears on the bottom of all pages.', 'shockmag' )
													),
								'projects'		=>	false,
								'footer'		=>	4,
								'bbPress'		=>	true,
								'buddyPress'	=>	true,
								'woocommerce'	=>	true,
								),
		'widgets'		=>	array (
								'sharrre'		=>	true,
								'contact-info'	=>	false,
								'flickr'		=>	false,
								'recent-posts'	=>	true,
								'recent-posts-subtitle'	=>	true,
								'subscribe'		=>	true,
								),
		'metaboxes'		=>	array (
								'sidebar'		=>	true,
								'post-options'	=>	true,
								),
		'megamenu'		=>	array (
								'sidebar'		=>	true,
								),
		'shortcodes'	=>	array (
								'status'		=>	true,
								'column'		=>	true,
								'ul'			=>	true,
								'button'		=>	true,
								'alert'			=>	true,
								'highlight'		=>	true,
								'dropcap'		=>	true,
								'pullquote'		=>	true,
								'toggle'		=>	true,
								'accordion'		=>	true,
								'tabs'			=>	true,
								'googlemap'		=>	true,
								'pricing-table'	=>	true,
								'sidebar'		=>	true,
								'clear'			=>	true,
								'notice'		=>	true,
								'skill'			=>	true,
								'icon-box'		=>	true,
								'gallery'		=>	false,	// ST gallery // [st-gallery]
								'gallery-owl'	=>	true,	// Owl gallery // [st-gallery]
								'gallery-by'	=>	'owl',	// Override default [gallery] shortcode by Owl gallery
								),
		'breadcrumbs'	=>	true,
		'font-st'		=>	true,
		'networks'		=>	array (
								'life_RSS',
								'life_Facebook',
								'life_GooglePlus',
								'life_VK',
								//'life_500px',
								'life_Behance',
								'life_Blogger',
								'life_Delicious',
								'life_DeviantART',
								//'life_Digg',
								//'life_Dopplr',
								'life_Dribbble',
								'life_Evernote',
								'life_Flickr',
								'life_Forrst',
								'life_GitHub',
								//'life_Grooveshark',
								'life_Instagram',
								'life_Lastfm',
								'life_LinkedIn',
								//'life_MySpace',
								//'life_Path',
								'life_Picasa',
								'life_Pinterest',
								//'life_Posterous',
								'life_Reddit',
								'life_Skype',
								'life_SoundCloud',
								'life_Spotify',
								'life_Stumbleupon',
								'life_Tumblr',
								'life_Twitter',
								//'life_Viddler',
								'life_Vimeo',
								//'life_Virb',
								'life_WordPress',
								'life_Youtube',
								//'life_Zerply'
								),
		'networks_path'	=>	'18/social/color/',
		'compatibility'	=>	array(
								'yoast'			=>	true,
								'woocommerce'	=>	array(
														'qty'			=>	9,
														'per-row'		=>	3,
														'related'		=>	3,
														'catalog'		=>	array( 250, 250, 1 ),
														'single'		=>	array( 400, 400, 0 ),
														'thumbnail'		=>	array( 150, 150, 1 ),
													),
								'wp-review'	=>	array(
														'hide'			=>	array( 'custom_colors', 'color', 'fontcolor', 'bgcolor1', 'bgcolor2', 'bordercolor' ),
														'exclude'		=>	array( 'page', 'product' ),
													),
							),
		'panel'			=>	array(
								'major'			=>	array (
														'status'	=>	true,
														'general'	=>	array(
																			'status'		=>	true,
																			'logo_img'		=>	true,
																			'favicon'		=>	false,
																			'copyrights'	=>	true,
																			'dev_link'		=>	true,
																			'analytics'		=>	false,
																			),
														'blog'		=>	array(
																			'status'		=>	true,
																			'template'		=>	array(
																									'default'			=>	array (
																																'label'			=> __( 'Default', 'shockmag' ),
																																'status'		=> true,
																																'desc'			=> __( 'This is standard template.', 'shockmag' ),
																																),
																									't1'				=>	array (
																																'label'			=> '1',
																																'status'		=> false,
																																'desc'			=> '',
																																),
																									't2'				=>	array (
																																'label'			=> '2',
																																'status'		=> false,
																																'desc'			=> '',
																																),
																									't3'				=>	array (
																																'label'			=> '3',
																																'status'		=> false,
																																'desc'			=> '',
																																),
																									't4'				=>	array (
																																'label'			=> '4',
																																'status'		=> false,
																																'desc'			=> '',
																																),
																									't5'				=>	array (
																																'label'			=> '5',
																																'status'		=> false,
																																'desc'			=> '',
																																),
																									't6'				=>	array (
																																'label'			=> '6',
																																'status'		=> true,
																																'desc'			=> __( 'Template with thumbnails.', 'shockmag' ),
																																),
																									't7'				=>	array (
																																'label'			=> '7',
																																'status'		=> false,
																																'desc'			=> '',
																																),
																									't8'				=>	array (
																																'label'			=> '8',
																																'status'		=> false,
																																'desc'			=> '',
																																),
																									't9'				=>	array (
																																'label'			=> '9',
																																'status'		=> false,
																																'desc'			=> '',
																																),
																									't10'				=>	array (
																																'label'			=> '10',
																																'status'		=> true,
																																'desc'			=> __( 'Template with thumbnails.', 'shockmag' ),
																																),
																									't11'				=>	array (
																																'label'			=> '11',
																																'status'		=> true,
																																'desc'			=> __( 'Template with thumbnails.', 'shockmag' ),
																																),
																									),
																			'featured'		=> array(
																									'sticky-status'				=>	true,
																									'sticky'					=>	false,
																									'sticky-cats'				=>	true,
																									'not-in-blogroll'			=>	true,
																									'on-frontpage'				=>	true,
																									'on-archives'				=>	true,
																									'on-single'					=>	false,
																									'on-others'					=>	false,
																									'cache'						=>	true,
																									'autoplay'					=>	true,
																									'most-viewed-status'		=>	true,
																									'most-viewed-period'		=>	true,
																									'most-viewed-on-frontpage'	=>	true,
																									'most-viewed-on-archives'	=>	true,
																									'most-viewed-on-single'		=>	true,
																									'most-viewed-on-others'		=>	true,
																									'most-viewed-cache'			=>	true,
																									),
																			),
														'post'		=> array(
																			'status'			=>	true,
																			'after_title'		=>	true,
																			'before_post'		=>	true,
																			'post_feat_image'	=>	true,
																			'excerpt'			=>	true,
																			'post_meta'			=>	array(
																										'status'		=>	true,
																										'author_info'	=>	true,
																										'post_views'	=>	true,
																										'nice_time'		=>	true
																										),
																			'after_post'		=>	true,
																			'post_comments'		=>	true,
																			'related'			=>	true,
																			'related-period'	=>	true,
																			),
														'page'		=> array(
																			'status'			=>	true,
																			'page_comments'		=>	true
																			),
														'sidebar'		=> array(
																			'status'			=>	true,
																			'additional'		=>	true,
																			'labels'			=>	true,
																			'options'			=>	true
																			),
														),
								'layout'		=>	array(
														'status'	=> true,
														'general'	=>	array(
																			'status'			=>	true,
																			'layout_type'		=>	true,
																			'layout_design'		=>	true,
																			),
														'header'	=>	array(
																			'status'			=>	true,
																			'templates'			=>	array('1','2','3','4','5'),
																			'scheme'			=>	array(
																										'status'			=>	true,
																										'default'			=>	'1',
																									),
																			),
														'footer'	=>	array(
																			'status'			=>	true,
																			'scheme'			=>	array(
																										'status'			=>	true,
																										'default'			=>	'4',
																									),
																			),
														'social'	=>	array(
																			'status'			=>	true,
																			),
														),
								'projects'		=>	array (
														'status'	=>	false,
														'general'	=>	array(
																			'status'			=>	true,
																			'slugs'				=>	true,
																			),
														'portfolio'	=>	array(
																			'status'			=>	true,
																			'projects_qty'		=>	true,
																			'templates'			=>	array (
																										'status'		=>	false,
																										'default'		=>	array (
																																'status'		=>	false,
																																'label'			=>	__( 'Default', 'shockmag' ),
																																'dummy'			=>	false,
																																),
																										't1'			=>	array (
																																'status'		=>	false,
																																'label'			=>	'1',
																																'dummy'			=>	false,
																																),
																										't2'			=>	array (
																																'status'		=>	false,
																																'label'			=>	'2',
																																'dummy'			=>	false,
																																),
																										't3'			=>	array (
																																'status'		=>	false,
																																'label'			=>	'3',
																																'dummy'			=>	false,
																																),
																										't4'			=>	array (
																																'status'		=>	false,
																																'label'			=>	'4',
																																'dummy'			=>	false,
																																),
																										't5'			=>	array (
																																'status'		=>	false,
																																'label'			=>	'5',
																																'dummy'			=>	false,
																																),
																										't6'			=>	array (
																																'status'		=>	false,
																																'label'			=>	'6',
																																'dummy'			=>	false,
																																)
																										),
																			'template-default'	=>	't5',
																			'another'			=>	true,
																			'another_qty'			=>	true,
																			'another_type'			=>	true,
																			'another_on-frontpage'	=>	true,
																			'another_on-archives'	=>	true,
																			'another_on-single'		=>	true,
																			'another_on-others'		=>	true,
																			'another_cache'			=>	true,
																			),
														'taxonomy'	=>	array(
																			'status'			=>	true,
																			),
														),
								'fonts'			=>	array(
														'status'	=>	true,
														'general'	=>	array(
																			'status'			=>	true,
																			'font_size'			=>	true,
																			'font_type'			=>	true,
																			'font_custom'		=>	true,
																			'font_custom_code'	=>	"<link href='http://fonts.googleapis.com/css?family=Open+Sans:700,300,800,400' rel='stylesheet' type='text/css'>",
																			'font_custom_css'	=>	"font-family: 'Open Sans', sans-serif;",
																			),
														),
								'style'			=>	array(
														'status'	=>	true,
														'general'	=>	array(
																			'status'			=>	true,
																			'styles'			=>	array(
																										'status'		=>	true,
																										'light' 		=>	array (
																																'status'		=>	'default',
																																'label'			=>	__( 'Light', 'shockmag' ),
																																),
																										'dark'			=>	array (
																																'status'		=>	true,
																																'label'			=>	__( 'Dark', 'shockmag' ),
																																),
																										),
																			'colors'			=>	array(
																										'status'		=>	true,
																										'default'		=>	'',
																										'primary'		=>	array(
																																'hex'			=>	'111111',
																																'free'			=>	array(
																																						'#header.header-bg:before { background: linear-gradient( to bottom, rgba(@@2rgb,0.25) 0%, rgba(@@2rgb,1) 100% ); }',
																																						'.post-title-with-img:before { background: linear-gradient( to bottom, rgba(@@2rgb,1) 0%, rgba(@@2rgb,0.25) 100% ); }',
																																						'#title-after { background: linear-gradient( to bottom, rgba(@@2rgb,1) 0%, rgba(@@2rgb,1) 50%, rgba(@@2rgb,0) 100% ); }',
																																						'.post-t6-yes-thumb a.post-thumb:before, .post-t10-yes-thumb a.post-thumb:before { background: linear-gradient( to right, rgba(@@2rgb,1) 0%, rgba(@@2rgb,0.25) 100% ); }',
																																						'.post-sticky-a-yes-thumb a > div:before { background: linear-gradient( to bottom, rgba(@@2rgb,0.25) 0%, rgba(@@2rgb,0.8) 100% ); }',
																																						'#search-form-holder form input:-webkit-autofill { -webkit-box-shadow: 0 0 0 1000px @@ inset; }',
																																						'#resp-top-panel { background-color: @@; border-top-color: @@; }',
																																						'@media only screen and ( min-width: 640px ) and ( max-width: 959px ) { #title-after { background: linear-gradient( to bottom, rgba(@@2rgb,0) 0%, rgba(@@2rgb,1) 100% ); } }',
																																						'@media only screen and ( min-width: 480px ) and ( max-width: 639px ) { #title-after { background: linear-gradient( to bottom, rgba(@@2rgb,0) 0%, rgba(@@2rgb,1) 100% ); } }',
																																						'@media only screen and ( max-width: 479px ) { #title-after { background: linear-gradient( to bottom, rgba(@@2rgb,0) 0%, rgba(@@2rgb,1) 100% ); } }',
																																						'ul.products > li.st-woo > a:first-child div.star-rating { box-shadow: 0 0 0 2px @@; }',
																																						'body.dark.woocommerce-page ul.products li.product:hover { outline: 10px solid @@; }',
																																						),
																																'color'			=>	array(
																																						'h1 a, h2 a, h3 a, h4 a, h5 a, h6 a',
																																						'.search-form-holder-button:before',
																																						'.bbp-body li.bbp-forum-info a.bbp-forum-title:before',
																																						'.bbp-body .bbp-meta a:hover',
																																						'.bbp-pagination .bbp-pagination-links span, .bbp-pagination .bbp-pagination-links a',
																																						'#members-list-options .selected',
																																						'#friends-list-options .selected',
																																						'#groups-list-options .selected',
																																						'ul.menu-2 > li > a',
																																						'.nav-next a, .nav-previous a',
																																						'#but-prev-next a',
																																						'#buddypress div.pagination div.pagination-links *',
																																						'.woocommerce .star-rating span:before, .woocommerce-page .star-rating span:before',
																																						'.widget_recently_viewed_products ins',
																																						'.widget_top_rated_products ins',
																																						'.woocommerce .cart-collaterals .cart_totals table th, .woocommerce-page .cart-collaterals .cart_totals table th, .woocommerce .cart-collaterals .cart_totals table td, .woocommerce-page .cart-collaterals .cart_totals table td',
																																						'.woocommerce .woocommerce-pagination ul.page-numbers li a:hover, .woocommerce-page .woocommerce-pagination ul.page-numbers li a:hover',
																																						'.dark #but-prev-next a:hover',
																																						),
																																'background-color'	=>	array(
																																						'caption',
																																						'#header.header-bg',
																																						'#header-holder',
																																						'#buddypress .activity-list li.loading a',
																																						'input[type="button"]:hover',
																																						'.breadcrumb-yoast',
																																						'.term-title',
																																						'#post-title',
																																						'.post-short-info',
																																						'#pre_next_post',
																																						'.st-post-share',
																																						'.post-t6-yes-thumb a.post-thumb',
																																						'.post-t10-yes-thumb a.post-thumb',
																																						'.post-sticky-a-yes-thumb',
																																						'.review-desc',
																																						'#review[class*=" wp-review-"] .user-review-area, .user-review-area',
																																						'#pbOverlay',
																																						'#pbImage',
																																						'.pricing-table-gray .pricing-table-title, .pricing-table-gray .pricing-table-price, .pricing-table-gray .button',
																																						'.pricing-table-dark .pricing-table-title, .pricing-table-dark .pricing-table-price, .pricing-table-dark .button',
																																						'.st-ul li',
																																						'.st-woo-hover',
																																						'.woocommerce-tabs',
																																						'.widget_price_filter',
																																						'.woocommerce .widget_layered_nav ul li.chosen a, .woocommerce-page .widget_layered_nav ul li.chosen a, .woocommerce .widget_layered_nav_filters ul li a, .woocommerce-page .widget_layered_nav_filters ul li a',
																																						'.dark #footer',
																																						'.dark .sidebar .widget-subscribe form > div',
																																						'.dark .single-author-info',
																																						'.dark.woocommerce-page ul.products li.product',
																																						'.dark.woocommerce .st-woo a.added_to_cart, .dark.woocommerce-page .st-woo a.added_to_cart',
																																						'.woocommerce #respond input#submit.loading, .woocommerce a.button.loading, .woocommerce button.button.loading, .woocommerce input.button.loading',
																																						'.dark .woocommerce .cart-collaterals .cross-sells ul.products li, .dark .woocommerce-page .cart-collaterals .cross-sells ul.products li',
																																						'.header-2 #menu-box',
																																						'.header-3 #header-layout',
																																						'.header-5 .sidebar-ad-a',
																																						'.header-4 #menu-box.menu-box-fixed',
																																						'.header-5 #menu-box',
																																						),
																																'border-top'	=>	array(
																																						),
																																'border-right'	=>	array(
																																						),
																																'border-bottom'	=>	array(
																																						),
																																'border-left'	=>	array(
																																						),
																																),
																										'primary-alt-a'	=>	array(
																																'steps'			=>	'20',
																																'free'			=>	array(
																																						//'.header-3 #menu-box:before { background: @@; }',
																																						),
																																'background-color'=> array(
																																						'.header-3 #menu-box:before',
																																						),
																																),
																										'secondary'		=>	array(
																																'hex'			=>	'e7a32a',
																																'free'			=>	array(
																																						'#buddypress button:hover, #buddypress a.button:hover, #buddypress a.button:focus, #buddypress ul.button-nav li a:hover, #buddypress ul.button-nav li.current a, #buddypress div.generic-button a:hover, #buddypress .comment-reply-link:hover { background-color: @@; border-color: @@; }',
																																						'#buddypress div#subnav { border-bottom-color: @@; }',
																																						'.status-header-links .ico16:hover:after { box-shadow: 0 0 0 13px @@ inset; }',
																																						'.post-t6 a.post-thumb:after { box-shadow: 0 0 0 7px @@ inset; }',
																																						'.post-t10 a.post-thumb:after { box-shadow: 0 0 0 7px @@ inset; }',
																																						'.tagcloud a:hover { border-bottom-color: @@; }',
																																						'ul.review-list { border-bottom-color: @@; }',
																																						'#layout div.review-total-only.small-thumb .review-result-wrapper i { color: @@ !important; }',
																																						'body.woocommerce-page ul.products li.product:hover { box-shadow: 0 0 0 10px @@; }',
																																						'.woocommerce div.product .woocommerce-tabs ul.tabs li.active { border-bottom-color: @@; }',
																																						'.woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce-page .widget_price_filter .ui-slider .ui-slider-handle { border-color: @@; }',
																																						),
																																'color'			=>	array(
																																						'h1 a:hover, h2 a:hover, h3 a:hover, h4 a:hover, h5 a:hover, h6 a:hover',
																																						'.title-sub',
																																						'a',
																																						'blockquote p:before',
																																						'blockquote cite',
																																						'#subscription-toggle a:before, #favorite-toggle a:before',
																																						'.widget_display_stats dd',
																																						'ul.menu ul.sub-menu li.hasUl > a:before',
																																						'#header li[class*="st-menu-col"] .st-menu-holder ul li a:before',
																																						'#menu-resp-holder > ul > li.stCurrent > span:before',
																																						'#menu-resp-holder ul ul ul li a:before',
																																						'#menu-resp-holder ul a i:before',
																																						'#menu-resp-holder li.current-menu-item a',
																																						'h1.post-title em',
																																						'#pre_next_post a em',
																																						'.post-t6-details h3 em',
																																						'.post-t10 h3 em',
																																						'#owl-most-viewed-nav span.prev:before, #owl-most-viewed-nav span.next:after',
																																						'.post-sticky-a h3 em',
																																						'.post-sticky-b h3 em',
																																						'.post-sticky-c h3 em',
																																						'#owl-sticky-nav span.prev:before',
																																						'#owl-sticky-nav span.next:after',
																																						'#prev a:hover:before, #next a:hover:after',
																																						'.widget_custom_menu i:before',
																																						'.widget_custom_menu > li.stCurrent > span:before',
																																						'.widget_custom_menu ul ul li a:before',
																																						'.widget_custom_menu > li > ul > li > ul > li.current-menu-item > a',
																																						'.widget-subscribe form > div:before',
																																						'.icons-social a:after',
																																						'li[class*="st-ico-menu-"] ul a > i:before',
																																						'.review-type-point, .review-type-point *, .review-type-percentage, .review-type-percentage *, .review-result-wrapper, .review-result-wrapper *',
																																						'div.review-result-wrapper i',
																																						'.review-list .review-star i, .review-list .review-result-wrapper .review-result i, #review[class*=" wp-review-"] .user-review-area .review-result-wrapper .review-result i, #review[class*=" wp-review-"] .user-review-area .review-total-star.allowed-to-rate a i, #review[class*=" wp-review-"] .review-list .review-result-wrapper i',
																																						'div.review-total-only.small-thumb',
																																						'.pullquote:after',
																																						'.accordion .toggle-opened .toggle-title',
																																						'.woocommerce ul.products li.product .onsale:before, .woocommerce-page ul.products li.product .onsale:before',
																																						'.woocommerce ul.products li.product h3 mark, .woocommerce-page ul.products li.product h3 mark',
																																						'.woocommerce .woocommerce-error:before, .woocommerce .woocommerce-info:before, .woocommerce .woocommerce-message:before, .woocommerce-page .woocommerce-error:before, .woocommerce-page .woocommerce-info:before, .woocommerce-page .woocommerce-message:before',
																																						'body.dark .tagcloud a, body.dark #footer .tagcloud a',
																																						'.dark ul.products > li.st-woo > a:first-child div.star-rating:before, .dark.woocommerce .star-rating:before',
																																						'.dark .woocommerce .star-rating span:before, .dark.woocommerce-page .star-rating span:before',
																																						'.dark #menu-responsive li.hasUl > span.opened:before',
																																						),
																																'background-color'	=>	array(
																																						'#layout .mejs-time-total, #layout .mejs-horizontal-volume-total',
																																						'.bbp-topic-pagination a',
																																						'#buddypress input[type="submit"], #buddypress input[type="button"], #buddypress input[type="reset"], #buddypress button.submit',
																																						'#buddypress input[type="submit"]:hover, #buddypress input[type="button"]:hover, #buddypress input[type="reset"]:hover, #buddypress button.submit:hover',
																																						'#buddypress .activity-list li.load-more a',
																																						'#menu-box',
																																						'ul.menu-2 > li > a:after',
																																						'input[type="button"]',
																																						'input[type="submit"], .dark input[type="submit"], button, .dark button',
																																						'.term-title h1:before',
																																						'#pre_next_post .p:after, #pre_next_post .n:after',
																																						'.st-post-share a:hover',
																																						'.st-format-link-holder .st-format-link a:before',
																																						'.post-sticky-a a > div:after',
																																						'#tabs-comments span.tab-comments-active:before',
																																						'.widget_rss h5 > a.rsswidget:first-child:before',
																																						'#wp-pagenavibox span.current:before',
																																						'.review-total-wrapper',
																																						'#scroll-to-top',
																																						'.button-st',
																																						'.st-ul li:not(.st-current):hover',
																																						'.pricing-table-featured .pricing-table-title, .pricing-table-featured .pricing-table-price, .pricing-table-featured .button',
																																						'.skill-bar',
																																						'.woocommerce #content input.button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce-page #content input.button, .woocommerce-page #respond input#submit, .woocommerce-page a.button, .woocommerce-page button.button, .woocommerce-page input.button',
																																						'.woocommerce #content input.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce-page #content input.button:hover, .woocommerce-page #respond input#submit:hover, .woocommerce-page a.button:hover, .woocommerce-page button.button:hover, .woocommerce-page input.button:hover',
																																						'.woocommerce #content input.button.alt, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce-page #content input.button.alt, .woocommerce-page #respond input#submit.alt, .woocommerce-page a.button.alt, .woocommerce-page button.button.alt, .woocommerce-page input.button.alt',
																																						'.woocommerce #content input.button.alt:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce-page #content input.button.alt:hover, .woocommerce-page #respond input#submit.alt:hover, .woocommerce-page a.button.alt:hover, .woocommerce-page button.button.alt:hover, .woocommerce-page input.button.alt:hover',
																																						'.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce-page .widget_price_filter .ui-slider .ui-slider-range',
																																						'.woocommerce .woocommerce-pagination ul.page-numbers li span.current:before, .woocommerce-page .woocommerce-pagination ul.page-numbers li span.current:before',
																																						'.header-4 ul.menu > li:before',
																																						'.header-5 ul.menu > li:before',
																																						'.header-2 ul.menu > li:before',
																																						'.header-2 #menu-box:not(.menu-box-fixed) ul.menu > li:before',
																																						'.header-3 ul.menu > li:before',
																																						'.header-3 #menu-box:not(.menu-box-fixed) ul.menu > li:before',
																																						'.st_icon_box:before',
																																						),
																																'border-top'	=>	array(
																																						),
																																'border-right'	=>	array(
																																						),
																																'border-bottom'	=>	array(
																																						),
																																'border-left'	=>	array(
																																						),
																																),
																										),
																			'background-image'	=>	'',
																			'responsive'		=>	true,
																			),
														'custom'	=>	array(
																			'status'			=>	true,
																			),
														),
								'misc'			=>	array(
														'status'	=>	true,
														'general'	=>	array(
																			'status'		=>	true,
																			),
														'admin_bar'		=>	true,
														'hidpi'			=>	true,
														'redirect'		=>	false,
														'stickymenu'	=>	true,
														'sidebar-alt'	=>	false,
														'cache-megamenu'=>	true,
														'smooth-scroll'	=>	true,
														'page-transition'=>	true,
														'gallery-default'=>	true,
														'adsense'		=>	true,
														'woocommerce'	=>	array(
																			'status'		=>	true,
																			'qty'			=>	true,
																			'assets'		=>	true,
																			),
														),
								'import'		=>	array(
														'status'	=>	true,
														),
								'update'		=>	array(
														'status'	=>	false,
														'general'	=>	array(
																			'status'		=>	true,
																			'source'		=>	'themeforest',
																			),
														),
								),
	); // $st_Options

?>