<?php if ( !defined( 'ABSPATH' ) ) exit;
/*

	Post formats compatible.

*/

	// Define classes
	$st_['class'] = has_post_thumbnail() ? 'post-template post-t6 post-t6-yes-thumb' : 'post-template post-t6 post-t6-no-thumb';

	// Define loop counter
	$st_['c'] = !isset( $st_['c'] ) ? $st_['count'] : $st_['c'] + 1;

	// Define featured counter
	$st_['feat'] = !isset( $st_['feat'] ) ? $st_['count'] : $st_['feat'] + 1;

	// Odd or Even?
	$st_['class'] .= $st_['count'] % 2 == 0 ? ' even' : ' odd';

	// First
	$st_['class'] .= $st_['c'] == 1 ? ' first' : '';

	// Second
	$st_['class'] .= $st_['c'] == 2 ? ' second' : '';

	// Third
	$st_['class'] .= $st_['c'] == 3 ? ' third' : '';

	// Featured
	$st_['class'] .= ( $st_['feat'] - 1 ) % 4 == 0 ? ' featured' : '';

	// Flush loop counter
	if ( $st_['c'] == 3 ) {	$st_['c'] = 0; }

	// Flush featured counter
	if ( $st_['feat'] == 9 ) { $st_['feat'] = 0; }


?>
<div class="<?php echo $st_['class']; ?>">

	<?php

		global
			$st_Options,
			$st_Settings;

			// Post format
			$st_['format'] = ( get_post_format( $post->ID ) && $st_Options['global']['post-formats'][get_post_format( $post->ID )]['status'] && function_exists( 'st_kit' ) ) ? get_post_format( $post->ID ) : 'standard';

			// Thumbnail
			if ( has_post_thumbnail() ) {	

				$st_['id'] = get_post_thumbnail_id( $post->ID );
				$st_['thumb'] = wp_get_attachment_image_src( $st_['id'], 'st-project-thumb' );
				$st_['thumb'] = $st_['thumb'][0];
				$st_['is_thumb'] = true;

			}
		
			else {
		
				$st_['is_thumb'] = false;
		
			}

			echo '<div class="thumb-wrapper" itemtype="http://schema.org/Article" itemscope="">';

				// Thumbnail
				echo '<a itemprop="url" rel="bookmark" href="' . esc_url( get_permalink() ) . '" class="post-thumb" ' . ( $st_['is_thumb'] == true && function_exists( 'st_get_2x' ) ? st_get_2x( $post->ID, 'st-project-thumb', 'attr' ) . ' style="background-image: url(' . $st_['thumb'] . ')"' : '' ) . ' data-format="' . $st_['format'] . '">';

					echo '<div>';

						// Meta
						echo function_exists( 'st_wp_get_post_terms' ) ? '<div class="meta"><span class="format-before format-' . $st_['format'] . '-before">' . st_wp_get_post_terms( $post->ID, 'category', false ) . '</span></div>' : '';
	
						// Review
						if ( function_exists( 'wp_review_show_total' ) ) {
							wp_review_show_total(); }
	
						// Details
						echo '<div class="post-t6-details">';
	
							// Subtitle
							$st_['subtitle'] = get_post_meta( $post->ID, 'subtitle_value', true );
			
							// Title and Excerpt
							echo '<h3 itemprop="name" class="post-title format-after format-' . $st_['format'] . '-after">' . esc_attr( get_the_title() ) . ( $st_['subtitle'] ? ' <em>' . esc_attr( $st_['subtitle'] ) . '</em>' : '' ) . '</h3>';
			
							echo '<div itemprop="description">' . wpautop( esc_attr( get_the_excerpt() ) ) . '</div>';
	
						echo '</div>';

					echo '</div>';

				echo '</a>';

				if ( function_exists('st_schema_org_article_itemscope') ) {
					echo st_schema_org_article_itemscope( false ); }

			echo '</div>' . "\n";

	?>

	<div class="clear"><!-- --></div>

</div><!-- .post-template -->