<?php if ( !defined( 'ABSPATH' ) ) exit;
/*

	Post formats compatible.

*/

	// Define classes
	$st_['class'] = has_post_thumbnail() ? 'post-template post-t10 post-t10-yes-thumb' : 'post-template post-t10 post-t10-no-thumb';

	// Define loop counter
	$st_['c'] = !isset( $st_['c'] ) ? $st_['count'] : $st_['c'] + 1;

	// Odd or Even?
	$st_['class'] .= $st_['count'] % 2 == 0 ? ' even' : ' odd';

	// First
	$st_['class'] .= ' first';


?>
<div class="<?php echo $st_['class']; ?>">

	<?php

		global
			$st_Options,
			$st_Settings;

			// Post format
			$st_['format'] = ( get_post_format( $post->ID ) && $st_Options['global']['post-formats'][get_post_format( $post->ID )]['status'] && function_exists( 'st_kit' ) ) ? get_post_format( $post->ID ) : 'standard';

			// Thumbnail
			if ( has_post_thumbnail() ) {	

				$st_['id'] = get_post_thumbnail_id( $post->ID );
				$st_['thumb'] = wp_get_attachment_image_src( $st_['id'], ( 'st-project-medium' ) );
				$st_['thumb'] = $st_['thumb'][0];
				$st_['is_thumb'] = true;

			}
		
			else {
		
				$st_['is_thumb'] = false;
		
			}

			// Gravatar
			$st_['upic'] = get_avatar( get_the_author_meta( 'user_email', $post->post_author ), '50' );

			// Date
			if ( !empty( $st_Settings['nice_time'] ) && $st_Settings['nice_time'] == 'yes' && function_exists( 'st_niceTime' ) ) {
				$st_['date'] = st_niceTime( $post->post_date_gmt ); }
			else {
				$st_['date'] = get_the_time( get_option('date_format'), $post->ID ); }

			echo '<div class="thumb-wrapper" itemtype="http://schema.org/Article" itemscope="">';

				// Thumbnail
				echo '<a itemprop="url" rel="bookmark" href="' . esc_url( get_permalink() ) . '" class="post-thumb" ' . ( $st_['is_thumb'] == true && function_exists( 'st_get_2x' ) ? st_get_2x( $post->ID, 'st-project-medium', 'attr' ) . ' style="background-image: url(' . $st_['thumb'] . ')"' : '' ) . ' data-format="' . $st_['format'] . '">';

					echo '<div>';

						// Meta
						echo function_exists( 'st_wp_get_post_terms' ) ? '<div class="meta"><span class="format-before format-' . $st_['format'] . '-before">' . st_wp_get_post_terms( $post->ID, 'category', false ) . '</span></div>' : '';
	
						// Review
						if ( function_exists( 'wp_review_show_total' ) ) {
							wp_review_show_total(); }

						// Subtitle
						$st_['subtitle'] = get_post_meta( $post->ID, 'subtitle_value', true );
		
						// Title
						echo '<h3 itemprop="name" class="post-title format-after format-' . $st_['format'] . '-after">' . esc_attr( get_the_title() ) . ( $st_['subtitle'] ? ' <em>' . esc_attr( $st_['subtitle'] ) . '</em>' : '' ) . '</h3>';

					echo '</div>';

					// Date, Author
					echo '<div class="post-t10-author">' . $st_['upic'] . sprintf( __( "%s by %s", 'shockmag' ), $st_['date'], '<span>' . get_userdata( $post->post_author )->display_name . '</span>' ) . '</div>';

					// Views
					st_post_meta( false, false, false, false, false, true );

				echo '</a>';

				if ( function_exists('st_schema_org_article_itemscope') ) {
					echo st_schema_org_article_itemscope( false ); }

			echo '</div>' . "\n";

	?>

	<div class="clear"><!-- --></div>

</div><!-- .post-template -->