<?php if ( !defined( 'ABSPATH' ) ) exit;

/*

	1 - FEATURED POSTS

*/

/*===============================================

	F E A T U R E D   P O S T S
	Sticky posts

===============================================*/

	global
		$st_Settings,
		$st_Options,
		$paged;

		$st_['temp'] = !empty( $st_query ) ? $st_query : '';
		$st_query = null;

		$st_['is_featured'] = false;
		$st_['is_others'] = false;
		$st_['sticky_posts'] = array_filter( get_option('sticky_posts') );
		$st_['posts_sticky'] = '';
		$st_['object_type'] = '';
		$st_['featured_type'] = 'recent';


		// If no one sticky post
		if ( empty( $st_['sticky_posts'] ) ) {
			return; }


		// If frontpage
		if ( is_front_page() && !empty( $st_Settings['sticky_on_frontpage'] ) == 'yes' && $paged == 1 ) {
			$st_['is_featured'] = true; }


		// If archives
		if (
			is_category() && !empty( $st_Settings['sticky_on_archives'] ) == 'yes' ||
			is_tag() && !empty( $st_Settings['sticky_on_archives'] ) == 'yes' ||
			get_query_var('post_format') && !empty( $st_Settings['sticky_on_archives'] ) == 'yes'
			) {

				$st_['is_featured'] = true;
				$st_['featured_type'] = 'archived';
				$st_['object'] = get_queried_object();

				// Unique args
				$st_['args'] = array(
					'post__in'				=> $st_['sticky_posts'],
					'posts_per_page'		=> 6,
					'order'					=> 'DESC',
					'orderby'				=> 'date',
					'paged'					=> $paged,
					'post_status'			=> 'publish',
					'ignore_sticky_posts'	=> 1,
					'tax_query'				=> array(
													array(
														'taxonomy'	=> $st_['object']->taxonomy,
														'field'		=> 'term_id',
														'terms'		=> $st_['object']->term_id
													)
												)
				);

				// Featured type
				$st_['object_type'] = !empty( $st_['object'] ) ? $st_['object']->taxonomy . '_' . $st_['object']->term_id : '';

				// Get transient
				if ( !empty( $st_Settings['sticky_cache'] ) ) {
					$st_query = get_transient( 'st_sticky_posts_' . $st_['object_type'] ); }

				// WP Query
				if ( $st_query == false ) {
		
					$st_query = new WP_Query( $st_['args'] );
					wp_reset_postdata();
		
					if ( !empty( $st_Settings['sticky_cache'] ) ) {
						set_transient( 'st_sticky_posts_' . $st_['object_type'], $st_query, 60 * 60 * 12 ); }
		
				}

				if ( $st_['object']->taxonomy == 'category' ) {

					$st_['att_id'] = get_option( 'st_category_image_' . $st_['object']->term_id );
					if ( $st_['att_id'] ) {
						$st_['cat_img'] = wp_get_attachment_image_src( $st_['att_id'], 'st-large' ); ?>

						<script type='text/javascript'>
							/* <![CDATA[ */
								var stStickyBg = new Array();

									stStickyBg[0] = "<?php echo $st_['cat_img'][0]; ?>";

							/* ]]> */
						</script><?php
					}

				}

			}


		// Continue or not?
		if ( $st_['is_featured'] == false ) {
			return; }


		// Default args
		if ( empty( $st_['object'] ) ) {

			if ( empty( $st_Settings['sticky_cats'] ) ) {
				return; }

			$st_['sticky_cats'] = preg_replace('/\s+/', '', $st_Settings['sticky_cats'] );
			$st_['sticky_cats'] = trim( $st_['sticky_cats'], ',' );
			$st_['sticky_cats'] = explode( ',', $st_['sticky_cats'] );
			$st_['count'] = 0;

			foreach( $st_['sticky_cats'] as $st_['sticky_cat'] ) {

				// Does the category exist?
				if ( !get_term_by( 'slug', $st_['sticky_cat'], 'category' ) ) {

					// Remove non-exist slug from array
					unset( $st_['sticky_cats'][$st_['count']] );
				
				}

				else {

					// Unique args
					$st_['args'][$st_['sticky_cat']] = array(
						'post__in'				=> $st_['sticky_posts'],
						'posts_per_page'		=> 6,
						'category_name'			=> $st_['sticky_cat'],
						'order'					=> 'DESC',
						'orderby'				=> 'date',
						'paged'					=> 1,
						'post_status'			=> 'publish',
						'ignore_sticky_posts'	=> 1
					);
	
					$st_query[$st_['sticky_cat']] = '';
	
					// Get transient
					if ( !empty( $st_Settings['sticky_cache'] ) ) {
						$st_query[$st_['sticky_cat']] = get_transient( 'st_sticky_posts_' . $st_['sticky_cat'] ); }
	
					// WP Query
					if ( $st_query[$st_['sticky_cat']] == false ) {
	
						$st_query[$st_['sticky_cat']] = new WP_Query( $st_['args'][$st_['sticky_cat']] );
						wp_reset_postdata();
	
						if ( !empty( $st_Settings['sticky_cache'] ) ) {
							set_transient( 'st_sticky_posts_' . $st_['sticky_cat'], $st_query[$st_['sticky_cat']], 60 * 60 * 12 ); }
	
					}

				}

				$st_['count']++;

			}

		}


		// Recent Sticky Posts
		if ( $st_['featured_type'] == 'recent' ) { ?>

			<script type='text/javascript'>
				/* <![CDATA[ */

					var stStickyCat = new Array();

						<?php

							echo "\n";
							$st_['count'] = 0;

							foreach( $st_['sticky_cats'] as $st_['sticky_cat'] ) {

								$st_['cat'] = get_term_by( 'slug', $st_['sticky_cat'], 'category' );
								echo 'stStickyCat[' . $st_['count'] . '] = "' . $st_['cat']->name . '";' . "\n";
								$st_['count']++;

							}

						?>

					var stStickyUrl = new Array();

						<?php

							echo "\n";
							$st_['count'] = 0;

							foreach( $st_['sticky_cats'] as $st_['sticky_cat'] ) {

								echo 'stStickyUrl[' . $st_['count'] . '] = "' . get_term_link( $st_['sticky_cat'], 'category' ) . '";' . "\n";
								$st_['count']++;

							}

						?>

					var stStickyBg = new Array();

						<?php

							echo "\n";
							$st_['count'] = 0;

							foreach( $st_['sticky_cats'] as $st_['sticky_cat'] ) {

								$st_['cat'] = get_term_by( 'slug', $st_['sticky_cat'], 'category' );
								$st_['att_id'] = get_option( 'st_category_image_' . $st_['cat']->term_id );
								if ( $st_['att_id'] ) {
									$st_['cat_img'] = wp_get_attachment_image_src( $st_['att_id'], 'full' );
									$st_['cat_img'] = $st_['cat_imgs'][] = $st_['cat_img'][0];
								}
								else {
									$st_['cat_img'] = 'none';
								}
								echo 'stStickyBg[' . $st_['count'] . '] = "' . $st_['cat_img'] . '";' . "\n";
								$st_['count']++;

							}

						?>

				/* ]]> */
			</script>

			<?php

				if ( !empty( $st_['cat_imgs'] ) ) {
					foreach( $st_['cat_imgs'] as $st_['url'] ) {
						echo $st_['url'] != 'none' ? "\n" . '<div style="background-image: url(' . $st_['url'] . ');"><!-- img --></div>' : '';
					}
				}
				
			if ( count( $st_['sticky_cats'] ) > 1 ) { ?>

				<div id="owl-sticky-cat"><!-- Current --></div>

				<div id="owl-sticky-nav">
				  <span class="prev"><!-- Prev --></span>
				  <span class="next"><!-- Next --></span>
				</div>

				<div class="clear"><!-- --></div><?php

			}

			if ( count( $st_['sticky_cats'] ) == 1 ) {
				echo '<div id="owl-sticky-nav-placeholder"><!-- placeholder --></div>'; }

			foreach( $st_['sticky_cats'] as $st_['sticky_cat'] ) {

				if ( $st_query[$st_['sticky_cat']]->found_posts ) {

					$st_['count'] = 0;
					$st_['posts_sticky'] .= '<div class="posts-sticky">';

						while ( $st_query[$st_['sticky_cat']]->have_posts() ) : $st_query[$st_['sticky_cat']]->the_post();

							$st_['count']++;

							include( get_template_directory() . '/includes/posts/loop-sticky.php' );

						endwhile;

					$st_['posts_sticky'] .= '</div>'; //.posts-sticky

				}

			}

		}


		// Archived Sticky Posts
		else {

			if ( $st_query->found_posts ) {

				$st_['count'] = 0;
				$st_['posts_sticky'] .= '<div class="posts-sticky">';

					while ( $st_query->have_posts() ) : $st_query->the_post();

						$st_['count']++;

						include( get_template_directory() . '/includes/posts/loop-sticky.php' );

					endwhile;

				$st_['posts_sticky'] .= '</div>'; //.posts-sticky

			}

		}


		// Out
		if ( $st_['posts_sticky'] ) {

			echo
				'<div id="owl-sticky" class="owl-carousel ' . 
				( $st_['featured_type'] == 'recent' ? 'owl-sticky-recent' : 'owl-sticky-archived' ) .
				( !empty( $st_Settings['sticky_autoplay'] ) == 'yes' ? ' autoplay-on' : '' ) . '">' .
					$st_['posts_sticky'] .
				'</div>' . "\n";

		}


		$st_query = null;
		$st_query = $st_['temp'];
		wp_reset_postdata();


?>

