<?php if ( !defined( 'ABSPATH' ) ) exit;

/*

	1 - MOST VIEWED POSTS

*/

/*===============================================

	M O S T   V I E W E D   P O S T S
	Most viewed posts

===============================================*/

	global
		$st_Settings,
		$st_Options,
		$paged;

		$st_['posts_per_page'] = 5;
		$st_['is_most_viewed'] = false;
		$st_['is_others'] = false;


		// If frontpage
		if ( is_front_page() && !empty( $st_Settings['most_viewed_on_frontpage'] ) == 'yes' && $paged == 1 ) {
			$st_['is_most_viewed'] = true; }


		// If archives
		if (
			is_category() && !empty( $st_Settings['most_viewed_on_archives'] ) == 'yes' ||
			is_tag() && !empty( $st_Settings['most_viewed_on_archives'] ) == 'yes' ||
			get_query_var('post_format') && !empty( $st_Settings['most_viewed_on_archives'] ) == 'yes'
			) {

				$st_['is_most_viewed'] = true;
				$st_['timeframe'] = !empty( $st_Settings['most_viewed_period'] ) ? $st_Settings['most_viewed_period'] : 'all';
				$st_['object'] = get_queried_object();

				// Unique args
				$st_['args'] = array(
					'posts_per_page'		=> $st_['posts_per_page'],
					'ignore_sticky_posts'	=> 1,
					'orderby'				=> 'meta_value_num',
					'meta_key'				=> 'post_views_count',
					'date_query'			=> ( $st_['timeframe'] != 'all' ? 
														array(
															array(
																'column'	=> 'post_date_gmt',
																'after'		=> '1 ' . $st_['timeframe'] . ' ago',
															),
														)
												: '' ),
					'tax_query'				=> array(
													array(
														'taxonomy'	=> $st_['object']->taxonomy,
														'field'		=> 'term_id',
														'terms'		=> $st_['object']->term_id
													)
												)
				);

			}


		// If single
		if (
			is_single() && !empty( $st_Settings['most_viewed_on_single'] ) == 'yes' && get_post_type() == 'post' ||
			is_single() && !empty( $st_Settings['most_viewed_on_single'] ) == 'yes' && get_post_type() == 'post' && function_exists('is_bbpress') && !is_bbpress()
			) {
				$st_['is_most_viewed'] = true;
			}


		// If others
		if ( !empty( $st_Settings['most_viewed_on_others'] ) == 'yes' && !is_single() && !is_category() && !is_tag() && !is_front_page() ) {
			$st_['is_most_viewed'] = true; }


		// Continue or not?
		if ( $st_['is_most_viewed'] == false ) {
			return; }


		$st_['timeframe'] = !empty( $st_Settings['most_viewed_period'] ) ? $st_Settings['most_viewed_period'] : 'all';


		// Default args
		if ( empty( $st_['object'] ) ) {

			$st_['args'] = array (
				'posts_per_page'		=> $st_['posts_per_page'],
				'ignore_sticky_posts'	=> 1,
				'orderby'				=> 'meta_value_num',
				'meta_key'				=> 'post_views_count',
				'date_query'			=> ( $st_['timeframe'] != 'all' ? 
													array(
														array(
															'column'	=> 'post_date_gmt',
															'after'		=> '1 ' . $st_['timeframe'] . ' ago',
														),
													)
											: '' )
			);

		}


		$st_['feat_type'] = !empty( $st_['object'] ) ? $st_['object']->taxonomy . '_' . $st_['object']->term_id : 'recent';


		$st_['temp'] = !empty( $st_query ) ? $st_query : '';
		$st_query = null;


		if ( !empty( $st_Settings['most_viewed_cache'] ) ) {
			$st_query = get_transient( 'st_most_viewed_posts_' . $st_['feat_type'] ); }


		if ( $st_query == false ) {

			$st_query = new WP_Query( $st_['args'] );
			wp_reset_postdata();

			set_transient( 'st_most_viewed_posts_' . $st_['feat_type'], $st_query, 60 * 60 * 12 );

		}

	?>

	<div id="posts-most-viewed">

		<div id="owl-most-viewed-nav">
			<div class="owl-most-viewed-nav">
			  <span class="prev non-selectable"><!-- Prev --></span>
			  <span class="next non-selectable"><!-- Next --></span>
			 </div>
		</div>

		<div class="posts-most-viewed v2">

			<div id="owl-most-viewed">

				<?php
			
					while ( $st_query->have_posts() ) : $st_query->the_post();		
		
						// Post format
						$st_['format'] = ( get_post_format( $post->ID ) && $st_Options['global']['post-formats'][get_post_format( $post->ID )]['status'] && function_exists( 'st_kit' ) ) ? get_post_format( $post->ID ) : 'standard';
		
						// Subtitle
						$st_['subtitle'] = get_post_meta( $post->ID, 'subtitle_value', true );

						// Define classes
						$st_['class'] = has_post_thumbnail() ? 'post-template post-t6 post-t6-yes-thumb' : 'post-template post-t6 post-t6-no-thumb';
					
						// Featured
						$st_['class'] .= ' featured';

						// Feat image
						if ( has_post_thumbnail() ) {
					
							$st_['id'] = get_post_thumbnail_id( $post->ID );
							$st_['thumb'] = wp_get_attachment_image_src( $st_['id'], 'st-project-thumb' );
							$st_['thumb'] = $st_['thumb'][0];
							$st_['is_thumb'] = true;
					
						}
					
						else {
					
							$st_['thumb'] = get_template_directory_uri() . '/assets/images/placeholder.png';
							$st_['is_thumb'] = false;
					
						}

							// Compose post
							echo '<div class="' . $st_['class'] . '">';

								echo '<div class="thumb-wrapper" itemtype="http://schema.org/Article" itemscope="">';
					
									// Thumbnail
									echo '<a itemprop="url" rel="bookmark" href="' . esc_url( get_permalink() ) . '" class="post-thumb" ' . ( $st_['is_thumb'] == true && function_exists( 'st_get_2x' ) ? st_get_2x( $post->ID, 'st-project-thumb', 'attr' ) . ' style="background-image: url(' . $st_['thumb'] . ')"' : '' ) . ' data-format="' . $st_['format'] . '">';

										echo '<div>';

											// Views
											echo '<div class="meta-views">'; st_post_meta( false, false, false, false, false, true, false ); echo '</div>';
	
											// Meta
											echo function_exists( 'st_wp_get_post_terms' ) ? '<div class="meta"><span class="format-before format-' . $st_['format'] . '-before">' . st_wp_get_post_terms( $post->ID, 'category', false ) . '</span></div>' : '';
						
											// Review
											if ( function_exists( 'wp_review_show_total' ) ) {
												wp_review_show_total(); }
						
											// Details
											echo '<div class="post-t6-details">';
						
												// Subtitle
												$st_['subtitle'] = get_post_meta( $post->ID, 'subtitle_value', true );
								
												// Title and Excerpt
												echo '<h3 itemprop="name" class="post-title format-after format-' . $st_['format'] . '-after">' . esc_attr( get_the_title() ) . ( $st_['subtitle'] ? ' <em>' . esc_attr( $st_['subtitle'] ) . '</em>' : '' ) . '</h3>';
								
												echo '<div itemprop="description">' . wpautop( esc_attr( get_the_excerpt() ) ) . '</div>';
						
											echo '</div>';

										echo '</div>';

									echo '</a>';

									if ( function_exists('st_schema_org_article_itemscope') ) {
										echo st_schema_org_article_itemscope( false ); }
					
								echo '</div>';

							echo '</div>' . "\n";
			
					endwhile;
		
				?>

		</div>

		<div class="clear"><!-- --></div></div>
	</div>

	<?php

	$st_query = null;
	$st_query = $st_['temp'];
	wp_reset_postdata();

?>