<?php
/*

	This is standard template for archives.
	Post formats compatible.

*/
?>
<div id="post-<?php the_ID(); ?>" <?php post_class('post-template post-default'); ?>>


	<?php

		global
			$st_Options;

			// More tag
			$more = 0;

			echo '<article itemtype="http://schema.org/Article" itemscope="">';

				// Category
				st_post_meta( false, false, true, false, false );

				// Subtitle
				$st_['subtitle'] = get_post_meta( $post->ID, 'subtitle_value', true );
	
				// Title
				if ( !empty($st_['title_disabled']) != 1 ) {
					echo '<header><h3 itemprop="name" class="post-title-default"><a itemprop="url" rel="bookmark" href="' . esc_url( get_permalink() ) . '">' . esc_attr( get_the_title() ) . ( $st_['subtitle'] ? ' <em>' . esc_attr( $st_['subtitle'] ) . '</em>' : '' ) . '</a></h3></header>'; }
	
				// Date
				st_post_meta( false, true, false, false, false );
	
				// Post format
				$st_['format'] = esc_attr( ( get_post_format( $post->ID ) && $st_Options['global']['post-formats'][get_post_format( $post->ID )]['status'] && function_exists( 'st_kit' ) ) ? get_post_format( $post->ID ) : 'standard' );

				include( get_template_directory() . '/includes/posts/formats/' . $st_['format'] . '.php' );
	
				// Content
				echo '<div class="post-format-' . $st_['format'] . '-content content-data">'; the_content(); echo '</div><div class="clear"><!-- --></div>';
		
				// Pagination
				if ( wp_link_pages( 'echo=0' ) ) {
	
					echo '<div class="page-pagination">';
	
						if ( function_exists('wp_pagenavi') ) {
							?><div id="wp-pagenavibox"><?php wp_pagenavi( array( 'type' => 'multipart' ) ); ?></div><?php } 
	
						else {
							wp_link_pages( array( 'before' => '<span>' . __( 'Pages', 'shockmag' ) . ':</span> ' ) ); }
	
					echo '</div>';
	
				}

				if ( function_exists('st_schema_org_article_itemscope') ) {
					echo st_schema_org_article_itemscope( false ); }

			echo '</article>';

			// Social share
			if ( function_exists( 'st_post_share' ) ) {
				echo st_post_share( $post->ID ); }

			/*-------------------------------------------
				2.5 - Related posts
			-------------------------------------------*/
		
			if ( !empty( $st_Settings['related'] ) == 'yes' && function_exists( 'st_related_posts' ) ) {

				$st_['query'] = st_related_posts( 2, '', 'h6', 'st-project-thumb', '', false, true );

				if ( $st_['query']->post_count > 0 ) {

					$st_['limit'] = 0;

					echo '<div class="v1 posts-related-wrapper">';

						echo '<div class="posts-related-title"><h6>' . __( 'You Might Also Like', 'shockmag' ) . '</h6></div>';

						while ( $st_['query']->have_posts() ) : $st_['query']->the_post();

							if ( $st_['count'] == $st_['limit'] ) { break; }

							$st_['count']++;

							include( get_template_directory() . '/includes/posts/t6.php' );

						endwhile;

					echo '<div class="clear"><!-- --></div></div>';

				}

			}

	?>

	<div class="clear"><!-- --></div>

</div><!-- .post-template -->