<?php if ( !defined( 'ABSPATH' ) ) exit; ?><!DOCTYPE html>

<html <?php language_attributes(); ?>>

	<head>
		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?> itemtype="http://schema.org/WebPage" itemscope="itemscope">

		<div id="search-form-holder">
			<form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get" class="div-as-table">
				<span class="non-selectable"></span>
				<div>
					<label>
						<input
							type="text"
							name="s"
							value=""
							placeholder="<?php _e( 'Type here and hit Enter', 'shockmag' ) ?>"
						/>
					</label>
				</div>
			</form>
		</div>

		<?php

			global
				$st_Options,
				$st_Settings;

			if ( !isset( $st_Settings['layout_type'] ) || $st_Options['panel']['style']['general']['responsive'] && !empty( $st_Settings['layout_type'] ) && $st_Settings['layout_type'] != 'standard' ) { ?>

				<div id="resp-top-panel">
					<span id="menu-resp-button"><!-- Menu button --></span>
					<span class="search-form-holder-button"><!-- Search button --></span>
				</div><?php

			}
		?>

		<div id="layout" class="<?php echo !empty( $st_Settings['page-transition'] ) == 'yes' ? 'opacity-0' : ''; ?>">

			<?php
				// Get header template
				$st_['header'] = !empty( $st_Settings['header_template'] ) ? $st_Settings['header_template'] : '1';
			?>

			<div id="header" class="header-<?php echo $st_['header']; ?>">

				<?php

					// Header
					get_template_part( '/includes/header/t' . $st_['header'] );

					// Posts sticky
					get_template_part( '/includes/posts/sticky' );

				?>

			</div><!-- #header -->

			<div id="content-parent">

				<div id="content-layout">

					<?php
				
						// Sidebar Ad B
						if ( is_front_page() || is_category() || is_tag() || get_query_var('post_format') ) {
							if ( is_active_sidebar( 'ad-sidebar-2' ) ) {
								get_template_part( '/includes/sidebars/sidebar_ad_b' ); }
						}

					?>