<?php if ( !defined( 'ABSPATH' ) ) exit;

/*

	1 - TGM

		1.1 - Include
		1.2 - Textdomain
		1.3 - Hook

*/

/*= 1 ===========================================

	T G M
	Plugin activation class

===============================================*/

	/*-------------------------------------------
		1.1 - Include
	-------------------------------------------*/

	require_once get_template_directory() . '/framework/functions/classes/class-tgm-plugin-activation.php';


	/*-------------------------------------------
		1.2 - Textdomain
	-------------------------------------------*/

	function st_tgm_textdomain() {

		load_theme_textdomain( 'tgmpa', get_template_directory() . '/framework/functions/classes/languages' );

	}

	add_action( 'after_setup_theme', 'st_tgm_textdomain' );


	/*-------------------------------------------
		1.3 - Hook
	-------------------------------------------*/

	function st_register_required_plugins() {
	
		$plugins = array(

			array(
				'name'     				=> 'Envato Market',
				'slug'     				=> 'envato-market',
				'source'   				=> 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
				'required' 				=> false,
				'version' 				=> '',
				'force_activation' 		=> false,
				'force_deactivation' 	=> false,
				'external_url' 			=> '',
			),

			array(
				'name'     				=> 'ST Kit',
				'slug'     				=> 'stkit',
				'source'   				=> 'http://strictthemes.com/to/download-stkit',
				'required' 				=> false,
				'version' 				=> '',
				'force_activation' 		=> false,
				'force_deactivation' 	=> false,
				'external_url' 			=> '',
			),

			array(
				'name'					=> 'WP-PageNavi',
				'slug'					=> 'wp-pagenavi',
				'required'				=> false,
			),

			array(
				'name'					=> 'WP Review',
				'slug'					=> 'wp-review',
				'required'				=> false,
			),

			array(
				'name'					=> 'WordPress SEO by Yoast',
				'slug'					=> 'wordpress-seo',
				'required'				=> false,
			),

			array(
				'name'					=> 'bbPress',
				'slug'					=> 'bbpress',
				'required'				=> false,
			),

			array(
				'name'					=> 'BuddyPress',
				'slug'					=> 'buddypress',
				'required'				=> false,
			),

			array(
				'name'					=> 'WooCommerce - excelling eCommerce',
				'slug'					=> 'woocommerce',
				'required'				=> false,
			),

			array(
				'name'					=> 'ADS PRO Multi-Purpose WordPress Ad Manager',
				'slug'					=> 'bsa-pro-scripteo',
				'source'				=> 'http://repo.strictthemes.com/third-party-plugins/bsa-pro-scripteo.zip',
				'required'				=> false,
			),

		);
	
		$config = array(
			'domain'       		=> 'shockmag',
			'default_path' 		=> '',
			'parent_menu_slug' 	=> 'themes.php',
			'parent_url_slug' 	=> 'themes.php',
			'menu'				=> 'tgmpa-install-plugins',
			'has_notices'      	=> true,
			'dismissable'		=> true,
			'dismiss_msg'		=> '',
			'is_automatic'    	=> false,
			'message' 			=> '',
			'strings'      		=> array(
				'page_title'                       			=> esc_html__( 'Install Required Plugins', 'shockmag' ),
				'menu_title'                       			=> esc_html__( 'Install Plugins', 'shockmag' ),
				'installing'                       			=> esc_html__( 'Installing Plugin: %s', 'shockmag' ), // %1$s = plugin name
				'oops'                             			=> esc_html__( 'Something went wrong with the plugin API.', 'shockmag' ),
				'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ), // %1$s = plugin name(s)
				'notice_can_install_recommended'			=> _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s)
				'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
				'notice_can_activate_recommended'			=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s)
				'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s)
				'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
				'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins' ),
				'return'                           			=> esc_html__( 'Return to Required Plugins Installer', 'shockmag' ),
				'plugin_activated'                 			=> esc_html__( 'Plugin activated successfully.', 'shockmag' ),
				'complete' 									=> esc_html__( 'All plugins installed and activated successfully. %s', 'shockmag' ), // %1$s = dashboard link
				'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
			)
		);
	
		tgmpa( $plugins, $config );
	
	}

	add_action( 'tgmpa_register', 'st_register_required_plugins' );



?>