<?php if ( !defined( 'ABSPATH' ) ) exit;

/*

	1 - RETRIEVE DATA

	2 - SIDEBARS

		- Default Sidebar
		- Secondary Sidebar
		- Post Sidebar
		- Ad Sidebars
		- Homepage Sidebars
		- Projects Sidebar
		- Footer Sidebars
		- bbPress Sidebar
		- Additional Sidebars

*/

	function st_register_sidebars() {


		/*===============================================
		
			R E T R I E V E   D A T A
			Get a required data
		
		===============================================*/
		
			global
				$st_Options,
				$st_Settings,
				$wp_registered_sidebars;
		
				$st_ = array();
		
		
		/*===============================================
		
			S I D E B A R S
			Register a new sidebars
		
		===============================================*/
		
			// Default Sidebar
			if ( $st_Options['sidebars']['default'] && !array_key_exists( 'default-sidebar', $wp_registered_sidebars ) ) {
				register_sidebars(
					1,
					array(
						'name'				=> 'Default Sidebar',
						'id'				=> 'default-sidebar',
						'description'		=> esc_html__( 'Appears on posts and pages by default.', 'shockmag' ),
						'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
						'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
						'before_title'		=> '<h5><span>',
						'after_title'		=> '</span></h5>' . "\n"
					)
				);
			}
		
		
			// Secondary Sidebar
			if ( $st_Options['sidebars']['secondary'] && !array_key_exists( 'secondary-sidebar', $wp_registered_sidebars ) ) {
				register_sidebars(
					1,
					array(
						'name'				=> 'Secondary Sidebar',
						'id'				=> 'secondary-sidebar',
						'description'		=> esc_html__( 'Appears on archives and homepage.', 'shockmag' ),
						'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
						'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
						'before_title'		=> '<h5><span>',
						'after_title'		=> '</span></h5>' . "\n"
					)
				);
			}
		
		
			// Post Sidebar
			if ( $st_Options['sidebars']['post-sidebar'] && !array_key_exists( 'post-sidebar', $wp_registered_sidebars ) ) {
				register_sidebars(
					1,
					array(
						'name'				=> 'Post Sidebar',
						'id'				=> 'post-sidebar',
						'description'		=> esc_html__( 'Additional sidebar. Usually, it comes by left side of post. Appears on posts only.', 'shockmag' ),
						'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
						'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
						'before_title'		=> '<h5><span>',
						'after_title'		=> '</span></h5>' . "\n"
					)
				);
			}
		
		
			// Ad Sidebars
			if ( $st_Options['sidebars']['ads'] ) {
		
				$st_['count'] = 0;
		
				foreach ($st_Options['sidebars']['ads'] as $key ) {
		
					$st_['count']++;

					if ( array_key_exists( 'ad-sidebar-' . $st_['count'], $wp_registered_sidebars ) ) {
						return; }

					register_sidebars(
						1,
						array(
							'name'				=> 'Ad Sidebar ' . $st_['count'],
							'id'				=> 'ad-sidebar-' . $st_['count'],
							'description'		=> $key,
							'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
							'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
							'before_title'		=> '<h5><span>',
							'after_title'		=> '</span></h5>' . "\n"
						)
					);
		
				}
		
			}
		
		
			// Homepage Sidebars
			if ( $st_Options['sidebars']['homepage'] ) {
		
				$st_['count'] = 0;
		
				foreach ( $st_Options['sidebars']['homepage'] as $key ) {
		
					$st_['count']++;
		
					register_sidebars(
						1,
						array(
							'name'				=> 'Homepage Sidebar ' . $st_['count'],
							'id'				=> 'homepage-sidebar-' . $st_['count'],
							'description'		=> $key,
							'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
							'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
							'before_title'		=> '<h5><span>',
							'after_title'		=> '</span></h5>' . "\n"
						)
					);
		
				}
		
			}
		
		
			// Projects Sidebar
			if ( $st_Options['sidebars']['projects'] && !array_key_exists( 'projects-sidebar', $wp_registered_sidebars ) ) {
				register_sidebars(
					1,
					array(
						'name'				=> 'Projects Sidebar',
						'id'				=> 'projects-sidebar',
						'description'		=> esc_html__( 'Appears on projects and archives of projects depends of selected template.', 'shockmag' ),
						'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
						'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
						'before_title'		=> '<h5><span>',
						'after_title'		=> '</span></h5>' . "\n"
					)
				);
			}
		
		
			// Footer Sidebars
			if ( $st_Options['sidebars']['footer'] ) {
				register_sidebars(
					$st_Options['sidebars']['footer'],
					array(
						'name'				=> 'Footer Sidebar %d',
						'id'				=> 'footer-sidebar',
						'description'		=> esc_html__( 'Appears on all pages at the bottom of site.', 'shockmag' ),
						'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
						'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
						'before_title'		=> '<h5><span>',
						'after_title'		=> '</span></h5>' . "\n"
					)
				);
			}
		
		
			// bbPress Sidebar
			if ( $st_Options['sidebars']['bbPress'] ) {
				register_sidebars(
					1,
					array(
						'name'				=> 'bbPress Sidebar',
						'id'				=> 'bbpress-sidebar',
						'description'		=> esc_html__( 'Appears on bbPress forum pages.', 'shockmag' ),
						'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
						'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
						'before_title'		=> '<h5><span>',
						'after_title'		=> '</span></h5>' . "\n"
					)
				);
			}
		
		
			// BuddyPress Sidebar
			if ( $st_Options['sidebars']['buddyPress'] ) {
				register_sidebars(
					1,
					array(
						'name'				=> 'BuddyPress Sidebar',
						'id'				=> 'buddypress-sidebar',
						'description'		=> esc_html__( 'Appears on BuddyPress pages.', 'shockmag' ),
						'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
						'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
						'before_title'		=> '<h5><span>',
						'after_title'		=> '</span></h5>' . "\n"
					)
				);
			}
		
		
			// WooCommerce Sidebar
			if ( $st_Options['sidebars']['woocommerce'] ) {
				register_sidebars(
					1,
					array(
						'name'				=> 'WooCommerce Sidebar',
						'id'				=> 'woocommerce-sidebar',
						'description'		=> esc_html__( 'Appears on WooCommerce pages.', 'shockmag' ),
						'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
						'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
						'before_title'		=> '<h5><span>',
						'after_title'		=> '</span></h5>' . "\n"
					)
				);
			}
		
		
			// Additional Sidebars
			if ( !empty( $st_Settings['sidebar_qty'] ) ) {

				for ( $st_['x'] = 0; $st_['x'] <= $st_Settings['sidebar_qty'] - 1; $st_['x']++ ) {

					$st_['args'] = array(
						'name'				=> esc_attr( !empty( $st_Settings['sidebar_labels'][$st_['x']] ) ? $st_Settings['sidebar_labels'][$st_['x']] : 'Custom bar ' . $st_['x'] ),
						'id'				=> 'custom-bar-' . $st_['x'],
						'description'		=> '',
						'before_widget'		=> "\n" . '<div class="widget %2$s">' . "\n",
						'after_widget'		=> "\n" . '<div class="clear"><!-- --></div></div>' . "\n",
						'before_title'		=> '<h5><span>',
						'after_title'		=> '</span></h5>' . "\n"
					);

					register_sidebar( $st_['args'] );

				}

			}


	}
	
	add_action( 'widgets_init', 'st_register_sidebars' );

?>