/*

	1 - MENU PRIMARY

		1.1 - Add class: hasUl
		1.2 - Action by hover
		1.3 - Action by click on iPad
		1.4 - 3rd level margin
		1.5 - Responsive menu: General
		1.6 - Responsive menu: Toggle
		1.7 - Responsive menu: Open sub-levels by click

	2 - MENU SECONDARY

		2.1 - Action by hover
		2.2 - 3rd level margin

	3 - MENU CUSTOM

		3.1 - Span sunbline
		3.2 - Span arrow
		3.3 - Current the class
		3.4 - Action by click

	4 - MEGAMENU

		4.1 - Megamenu
		4.2 - Menu icons
		4.3 - Menu columns

	5 - THEME RELATED

		5.1 - Related posts
		5.2 - Author info expand
		5.3 - Owl slider (sticky)
		5.4 - Owl slider (most viewed)
		5.5 - Responsive top bar: Logo
		5.6 - Responsive top bar: On\Off
		5.7 - Sticked menu
		5.8 - Page transition

	6 - COMMON

		6.1 - Detect browser name
		6.2 - Dinamic styles holder
		6.3 - Quick reply form
		6.4 - Textarea animation by focus
		6.5 - Tag cloud
		6.6 - Archives widget span
		6.7 - Image original side
		6.8 - Max size for YouTube & Vimeo video
		6.9 - ST Gallery
		6.10 - Search form on header
		6.11 - BuddyPress fixes
		6.12 - For IE only
		6.13 - WooCommerce
		6.14 - Webkit fixes
		6.15 - Comment tabs

	7 - SESSIONS & INTERVALS

		7.1 - Set content holder width
		7.2 - Set current scroll

	8 - ACTIONS BY LOADING

		8.1 - Flickr widget 150px thumbnails
		8.2 - Scroll to top button
		8.3 - Keep content within box
		8.4 - Sticked sidebars

	9 - JAVA SCRIPT

		9.1 - For IE only

*/

/* jshint -W099 */
/* global jQuery:false */

var st = jQuery.noConflict();

st(function(){

	'use strict';

/*==1.===========================================

	M E N U   P R I M A R Y
	Primary menu on header

===============================================*/

	/*-------------------------------------------
		1.1 - Add class: hasUl
	-------------------------------------------*/

	//st('.menu li:has(ul), .menu-2 li:has(ul)').addClass('hasUl').find('ul:not(.st-mega-holder)').addClass('sub-menu');
	st('.menu li:not(.st-megamenu-sidebar):has(ul), #header-holder .menu li.st-megamenu-sidebar, .menu-2 li:not(.st-megamenu-sidebar):has(ul), #header-holder .menu-2 li.st-megamenu-sidebar').addClass('hasUl');
	st('.menu > li:not(.st-megamenu-sidebar), .menu-2 > li:not(.st-megamenu-sidebar)').each(function(){

		st('li:has(ul), li:has(ul)',this).find('ul').addClass('sub-menu');

	});


	/*-------------------------------------------
		1.2 - Action by hover
	-------------------------------------------*/

	st('.menu li:has(ul), .menu-2 li:has(ul)')

		.hover(

			function(){
				if ( sessionStorage.getItem( 'st_content_holder_width' ) > 935 ) {
					st(this).addClass('hover-has-ul');
				}
			},

			function(){
				st(this).removeClass('hover-has-ul');
			}

		);


	/*-------------------------------------------
		1.3 - Action by click on iPad
	-------------------------------------------*/

	st('.menu li:has(ul) > a, .menu-2 li:has(ul) > a')

		.toggle(

			function(){
				if ( sessionStorage.getItem( 'st_content_holder_width' ) < 936 ) {
					st(this).parent().addClass('hover-has-ul');
					return false;
				}
				else {
					window.location.href = st(this).attr('href');
				}
			},

			function(){
				if ( sessionStorage.getItem( 'st_content_holder_width' ) < 936 ) {
					st(this).parent().removeClass('hover-has-ul');
					return false;
				}
				else {
					window.location.href = st(this).attr('href');
				}
			}

		);


	/*-------------------------------------------
		1.4 - 3rd level margin
	-------------------------------------------*/

		st('.menu li:not(.st-megamenu-sidebar) ul li:has(ul), .menu-2 li:not(.st-megamenu-sidebar) ul li:has(ul)')
	
			.hover(function(){

				var t = st(this).height() + 5;

				st('ul',this).css({margin: '-' + t + 'px 0 0 0'});

			});


	/*-------------------------------------------
		1.5 - Responsive menu: General
	-------------------------------------------*/

	var	st_resp_menu = {};
		st_resp_menu.menu_1 = st('#menu .menu').html() !== undefined ? st('#menu .menu').html() : '';
		st_resp_menu.menu_2 = st('#menu-2 .menu-2').html() !== undefined ? st('#menu-2 .menu-2').html() : '';

		st('body').append('<div id="menu-resp-holder"><ul>' + st_resp_menu.menu_1 + st_resp_menu.menu_2 + '</ul></div>');
		st('#menu-resp-holder > ul > li.hasUl').append('<span>&nbsp;</span>');

		st('#menu-resp-holder .st-megamenu-sidebar .st-mega-holder',this).next().remove();
		st('#menu-resp-holder .st-megamenu-sidebar .st-mega-holder',this).remove();


	/*-------------------------------------------
		1.6 - Responsive menu: Toggle
	-------------------------------------------*/

	st('#menu-resp-button').toggle(
		function() {
	
			st('body').addClass('menu-resp-on').css( 'overflow-x', 'hidden' );
			//st('html, body').animate({ scrollTop: 0 }, 1000 );
	
		},
		function() {
	
			st('body').removeClass('menu-resp-on');
			setTimeout( function(){ st('body').css( 'overflow-x', 'visible' ); }, 500 );
	
		}
	);


	/*-------------------------------------------
		1.7 - Responsive menu: Open sub-levels by click
	-------------------------------------------*/

	st('body').on( 'click tap', '#menu-resp-holder > ul > li > span', function(){

		var
			parent = st(this).parent();

			if ( parent.hasClass('stCurrent') ) {

				parent.removeClass('stCurrent');

			}

			else {

				parent.addClass('stCurrent');

			}

	});


/*==2.===========================================

	M E N U   S E C O N D A R Y
	Secondary menu on header

===============================================*/

	// Same as Primary menu


/*==3.===========================================

	M E N U   C U S T O M
	Standard widget

===============================================*/

	/*-------------------------------------------
		3.1 - Span sunbline
	-------------------------------------------*/

	st('.widget_custom_menu > li > a, .widget_custom_menu > li > ul > li > a').each(function(){

		var
			title = st(this).attr('title');

			if ( title ) {
				st(this).append('<span class="subline">' + title + '</span>').removeAttr('title'); }

	});

	/*-------------------------------------------
		3.2 - Span arrow
	-------------------------------------------*/

	st('.widget_custom_menu > li:has(ul)').append('<span>&nbsp;</span>');


	/*-------------------------------------------
		3.3 - Current the class
	-------------------------------------------*/

	st('.widget_custom_menu > li.current-menu-ancestor:has(ul)').addClass('stCurrent');


	/*-------------------------------------------
		3.4 - Action by click
	-------------------------------------------*/

	st('.widget_custom_menu span').click(function(){

		var
			parent = st(this).parent();

			if ( parent.hasClass('stCurrent') ) {

				parent.removeClass('stCurrent');

			}

			else {

				parent.addClass('stCurrent');

			}

	});


/*==4.===========================================

	M E G A M E N U
	Advanced version of menu

===============================================*/

	/*-------------------------------------------
		4 - Megamenu
	-------------------------------------------*/

	/*
	
		4.1.1 - If taxonomy: Extract taxonomy attributes
		4.1.2 - If single: Extract post id
		4.1.3 - Set holder for mega menu
		4.1.4 - Define position by left
		4.1.5 - Action by hover
		4.1.6 - Action by click on iPad
		4.1.7 - Pagination
		4.1.8 - Call AJAX
		4.1.9 - AJAX: Taxonomy
		4.1.10 - AJAX: Single

	*/

	/*- 4.1.1 - If taxonomy: Extract taxonomy attributes
	-------------------------------------------*/

	st('#header li[class*="st-mega-taxonomy-"] > a').each(function(){

		function st_mega_ignored(a){
			var
				classes = ( a.parent().attr('class') ).replace('st-mega-','st-ignored-');
				a.parent().attr('class',classes);
		}

		var
			check = st(this).attr('href').split('?');

			// Stop if default WP permalinks
			if ( typeof check[1] !== 'undefined' ) {
				st_mega_ignored( st(this) );
				return;
			}

			// 1 - Get the post type
			var
				post_type = ( ( st(this).parent().attr('class').split('st-mega-taxonomy-') )[1] ).split('-v-')[0];

			// 2 - Get the taxonomy
			var
				taxonomy = ( ( st(this).parent().attr('class').split('menu-item-object-') )[1] );

				if ( taxonomy.split(' ')[1] ) { // if not the last in list of classes
					taxonomy = taxonomy.split(' ')[0]; }

			// 3 - Get the field
			var
				field = 'slug';

			// 4 - Get the terms
			// Term of top taxonomy
			var
				terms = st(this).attr('href').split( stData[3] )[1].split('/')[2];

				// If sub-menu exists
				var
					sub_menu = st(this).next();

					if ( typeof sub_menu !== 'undefined' ) {
	
						st(this).next().children('li').each(function(){
	
							// Pass sub-menu items which is not categories
							/*var
								term_sub = st(this).children('a').attr('href').split( stData[3] )[1].split('/')[2];

								if ( typeof term_sub !== 'undefined' || term_sub !== '' ) {

									terms += ' ' + term_sub;
		
								 }*/

						});
	
					}

			// 5 - Get the requested version of template
			var
				version = ( ( st(this).parent().attr('class').split('-v-') )[1] ).split(' ')[0];

			// Apply attributes
			st(this).parent()
				.data( 'post_type', post_type )
				.data( 'taxonomy', taxonomy )
				.data( 'field', field )
				.data( 'terms', terms )
				.data( 'version', version * 1 );

	});


	/*- 4.1.2 - If single: Extract post id
	-------------------------------------------*/

	/* Dropped */


	/*- 4.1.3 - Set holder for mega menu
	-------------------------------------------*/

	st('#header li[class*="st-mega-"]').each(function(){

		if ( !st('ul',this).length ) {
			st(this).addClass('hasUl').append('<ul class="st-mega-holder none"><li></li></ul>');
		}


	});

	// Set position by left
	if ( st('#header').data('st-mega-position') !== 'started' ) {

		if ( st('#header li[class*="st-mega-"]').length ) {
			setInterval( st_mega_position, 1500 ); }

		st('#header').attr('data-st-mega-position','started');

	}


	/*- 4.1.4 - Define position by left
	-------------------------------------------*/

	function st_mega_position(){

		/*
			If Header 1
			If Header 3
			If Header 4
			If Header 5
		*/
		if ( st('#header').hasClass('header-1') || st('#header').hasClass('header-4') || st('#header').hasClass('header-5') ) {
	
			st('#header li[class*="st-mega-"] > .st-mega-holder, #header li[class*="st-megamenu-"] > .st-mega-holder').each(function(){
	
				var
					menuPosition = st(this).parent().parent().css('margin-left').replace('px','') * 1,
					liMargin = st(this).parent().css('margin-left').replace('px','') * 1,
					liPosition = st(this).parent().position().left * 1,
					liPositionPrevious = st(this).attr('data-position') * 1;

					if ( Math.floor( menuPosition + liPosition + liMargin ) !== liPositionPrevious ) {
	
						st(this).css({ 'transform': 'translate(-' + Math.floor( menuPosition + liPosition + liMargin ) + 'px,0)' }).removeClass('none');
	
						st(this).attr( 'data-position', Math.floor( menuPosition + liPosition + liMargin ) );
	
					}
	
			});
	
		}

		/*
			If Header 2
		*/
		if ( st('#header').hasClass('header-2') || st('#header').hasClass('header-3') ) {

			st('#header li[class*="st-mega-"] > .st-mega-holder, #header li[class*="st-megamenu-"] > .st-mega-holder').each(function(){
	
				var
					headerWidth = st('#header-holder').width(),
					logoWidth = st('#logo').outerWidth(true),
					liMargin = st(this).parent().css('margin-left').replace('px','') * 1,
					liPosition = st(this).parent().position().left * 1,
					liPositionPrevious = st(this).attr('data-position') * 1;

					// If header-2 but sticky
					if ( st('#header').hasClass('header-2') && st(this).parent().parent().parent().parent().parent().hasClass('menu-fixed') ) {
						logoWidth = 0; }

					// If header-3
					if ( st('#header').hasClass('header-3') ) {
						logoWidth = st(this).parent().parent().hasClass('menu') ? 0 : st('#logo').outerWidth(true); }

					if ( Math.floor( logoWidth + liPosition + liMargin ) !== liPositionPrevious ) {

						st(this).css({ 'transform': 'translate(-' + Math.floor( logoWidth + liPosition + liMargin ) + 'px,0)' }).removeClass('none');

						st(this).attr( 'data-position', Math.floor( logoWidth + liPosition + liMargin ) );
	
					}

			});

		}

	}



	/*- 4.1.5 - Action by hover
	-------------------------------------------*/

	st('#header li[class*="st-mega-"]')

		.hover(

			function(){

				if ( sessionStorage.getItem( 'st_content_holder_width' ) > 935 ) {

					st_mega_ajax_taxonomy( st(this) );

				}

			},

			function(){

				st(this).removeClass('hover-has-ul');

			}

		);


	/*- 4.1.6 - Action by click on iPad
	-------------------------------------------*/

	st('#header li[class*="st-mega-"] > a')

		.toggle(

			function(){

				if ( sessionStorage.getItem( 'st_content_holder_width' ) < 936 ) {

					st('#header .hover-has-ul').removeClass('hover-has-ul');

					st_mega_ajax_taxonomy( st(this).parent() );
					
					return false;

				}
				else {

					window.location.href = st(this).attr('href');

				}

			},

			function(){

				if ( sessionStorage.getItem( 'st_content_holder_width' ) < 936 ) {

					st(this).parent().removeClass('hover-has-ul');

					return false;

				}
				else {

					window.location.href = st(this).attr('href');

				}

			}

		);


	/*- 4.1.7 - Pagination
	-------------------------------------------*/

	st('#header').on( 'click', '.st-mega-nav a', function(){

		// Enable preloader
		st( '#' + st(this).data('holder_id') ).addClass('st-mega-loading');

		// Return requested posts
		st_mega_get_ajax_taxonomy([
			st(this).data('holder_id'),
			st(this).data('post_type'),
			st(this).data('taxonomy'),
			st(this).data('field'),
			st(this).data('terms'),
			st(this).data('version'),
			st(this).data('paged')
		]);

		return false;

	});


	/*- 4.1.8 - Call AJAX
	-------------------------------------------*/

	function st_mega_ajax_taxonomy( li ){

		var
			width = st('body').width(),
			st_mega_holder = st('.st-mega-holder > li',li);

			if ( width > 942 ) {

				li.addClass('hover-has-ul');

				// If holder is empty
				if ( !st_mega_holder.hasClass('st-mega-loaded') ) {

					// Enable preloader
					st_mega_holder.addClass('st-mega-loading st-mega-loaded');

					// define id for holder
					var holder_id = 'st-mega-' + li.data('terms').replace(/ /g,'-');
					st('ul.st-mega-holder > li',li).attr( 'id', holder_id );

					var	check = '';

					// AJAX: Taxonomy
					check = li.attr('class').split('st-mega-taxonomy-');
					if ( typeof check[1] !== 'undefined' ) {

						st_mega_get_ajax_taxonomy([
							holder_id,
							( li.data('post_type') ? li.data('post_type') : 'none' ),
							( li.data('taxonomy') ? li.data('taxonomy') : 'none' ),
							( li.data('field') ? li.data('field') : 'none' ),
							( li.data('terms') ? li.data('terms') : 'none' ),
							( li.data('version') ? li.data('version') : '1' )
						]);

					}

					// AJAX: Single
					else {

						check = li.attr('class').split('st-mega-single-');
						if ( typeof check[1] !== 'undefined' ) {

							st_mega_ajax_single([
								holder_id,
								li.data('post_id')
							]);

						}

					}

				}

			}

	}


	/*- 4.1.9 - AJAX: Taxonomy
	-------------------------------------------*/

	function st_mega_get_ajax_taxonomy( args ) {

		var
			st_mega_holder = st( '#' + args[0] ),
			paged = args[6] ? args[6] : '1';

		// Return cached data
		if ( localStorage && localStorage.getItem( args[0] + '_' + paged ) ) {

			var
				cache = JSON.parse( localStorage.getItem( args[0] + '_' + paged ) ),
				dateOld = cache.timestamp,
				dateNew = new Date().getTime().toString();

				if ( dateNew - dateOld < 60 * 60 * 1000 ) { // 1 hour

					// Drop cached posts
					st_mega_holder.hide().html(cache.value).removeClass('st-mega-loading').fadeIn();

				}

				else {

					// Call fresh posts
					st_mega_return_ajax_taxonomy( args );

				}

		}

		// Return AJAX data
		else {

			st_mega_return_ajax_taxonomy( args );

		}

	}

	function st_mega_return_ajax_taxonomy( args ) {

		/*
			args[0] - Holder ID
			args[1] - Post type e.g. post, product
			args[2] - Taxonomy e.g. category, post_tag
			args[3] - Field e.g. slug, or something custom
			args[4] - Terms e.g. fashion, music
			args[5] - Template version
			args[6] - Paged
			args[7] - Posts per page
		*/

		var
			st_mega_holder = st( '#' + args[0] ),
			paged = args[6] ? args[6] : '1';

		var
			data = {
				'action':		'st_mega_taxonomy',
				'holder_id':	args[0],
				'post_type':	args[1],
				'taxonomy':		args[2],
				'field':		args[3],
				'terms':		args[4],
				'version':		args[5],
				'paged':		paged,
				'qty':			args[7]
			};
	
			st.post( ajaxurl, data, function(response) {

				if ( response.length ) {

					// Drop posts
					st_mega_holder.hide().html(response).removeClass('st-mega-loading').fadeIn();

					// Remove previous cached copy
					localStorage.removeItem( args[0] + '_' + paged );

					// Set a fresh cached copy
					var cache = { timestamp: new Date().getTime(), value: response };
						localStorage.setItem( args[0] + '_' + paged, JSON.stringify(cache) );

				}
				else {
					st_mega_holder.hide().removeClass('st-mega-loading').html('Nothing matched your criteria.').fadeIn();
				}

			});

	}


	/*- 4.1.10 - AJAX: Single
	-------------------------------------------*/

	var
		st_mega_ajax_single = function( args ) {

			/* none */

		};


	/*-------------------------------------------
		4.2 - Menu icons (must be before Menu columns)
	-------------------------------------------*/

	st('li[class*="st-ico-menu-"] > a').each(function(){

		var
			a = ( st(this).parent().attr('class').split('st-ico-menu-')[1] ),
			content = ( a !== undefined ? a.split(' ')[0] : '' );

			st(this).html( '<i data-content="&#x' + content + ';"><!-- icon --></i>' + st(this).html() ).addClass('has-st-i');

	});


	/*-------------------------------------------
		4.3 - Menu columns
	-------------------------------------------*/

	st('#header li[class*="st-menu-col-"]').each(function(){

		st(this).append('<ul class="st-menu-holder">' + st(this).children('ul').html() + '</ul>');

	});

	st('#header ul.st-menu-holder ul, ul.st-menu-holder li').each(function(){

		st(this).removeAttr('class');

	});

	/*- 4.3.1 - Define position by left
	-------------------------------------------*/

	//if ( st('#header li[class*="st-menu-col-"]').length ) {
	//	setInterval( st_menu_col_position, 2300 ); }

	function st_menu_col_position(){

		/*
			If Header 2
		*/

		if ( st('#header').hasClass('header-2') ) {

			st('#header li[class*="st-menu-col-"] > ul.st-menu-holder').each(function(){
	
				var
					thisWidth = st(this).width(),
					headerWidth = st('#header-holder').width(),
					logoWidth = st('#logo').outerWidth(true),
					liMargin = st(this).parent().css('margin-left').replace('px','') * 1,
					liPosition = st(this).parent().position().left * 1,
					liPositionPrevious = st(this).attr('data-position') * 1;

					// If header-2 sticky
					if ( st(this).parent().parent().parent().parent().parent().hasClass('menu-fixed') ) {
						logoWidth = 0; }

				var
					thisMax = Math.floor( logoWidth + liPosition + liMargin + thisWidth );

					if ( ( thisMax - headerWidth ) !== liPositionPrevious * 1 ) {

						if ( thisMax > headerWidth ) {
	
							st(this).css({ 'transform': 'translate(-' + ( thisMax - headerWidth ) + 'px,0)' });
							st(this).attr( 'data-position', thisMax - headerWidth );
	
						}
	
						else {
	
							st(this).css({ 'transform': 'translate(0,0)' });
							st(this).attr( 'data-position', '0' );
	
						}
	
					}
	
			});

		}

		/*
			Else if any Header
		*/

		else {

			st('#header li[class*="st-menu-col-"] > ul.st-menu-holder').each(function(){
	
				var
					thisWidth = st(this).width(),
					headerWidth = st('#header-holder').width(),
					menuPosition = st(this).parent().parent().css('margin-left').replace('px','') * 1,
					liMargin = st(this).parent().css('margin-left').replace('px','') * 1,
					liPosition = st(this).parent().position().left * 1,
					liPositionPrevious = st(this).attr('data-position') * 1,
					offset = 0;



					if ( st('#header').hasClass('header-3') && st(this).parent().parent().hasClass('menu-2') ) {
						offset = st('#logo').outerWidth(true); }

				var
					thisMax = Math.floor( offset + menuPosition + liPosition + liMargin + thisWidth );

					if ( ( thisMax - headerWidth ) !== liPositionPrevious * 1 ) {

						if ( thisMax > headerWidth ) {
	
							st(this).css({ 'transform': 'translate(-' + ( thisMax - headerWidth ) + 'px,0)' });
							st(this).attr( 'data-position', thisMax - headerWidth );
	
						}
	
						else {
	
							st(this).css({ 'transform': 'translate(0,0)' });
							st(this).attr( 'data-position', '0' );
	
						}
	
					}
	
			});

		}

	}

	setTimeout( st_menu_col_position, 1200 );
	//st_menu_col_position();
	st(window).resize( st_menu_col_position );


/*==5.===========================================

	T H E M E   R E L A T E D
	Scritps for certain theme

===============================================*/

	/*-------------------------------------------
		5.1 - Related posts
	-------------------------------------------*/

	function st_related_posts_height() {

		var
			rHeightDetails = 0;

			st('.posts-related-details-wrapper > div').each(function(){

				if ( st(this).outerHeight() > rHeightDetails ) {
					rHeightDetails = st(this).outerHeight(); }

			});

			st('.posts-related-wrapper .posts-related-details-wrapper').stop(true, false).animate({ 'height': rHeightDetails }, 250, function(){ st(this).eq(0).animate({ 'opacity': '1' }, 500); });

	}

	function st_the_related_posts_height() {
		setTimeout( st_related_posts_height, 1000 );
	}

	st_the_related_posts_height();

	st(window).resize( st_the_related_posts_height );


	/*-------------------------------------------
		5.2 - Author info expand
	-------------------------------------------*/

	st('.author .status-content.cutted-closed > div, .page-template-template-authors-php .status-content.cutted-closed > div, .single-author-info .status-content.cutted-closed > div').toggle(function() {

		st(this).parent().removeClass('cutted-closed').addClass('cutted-opened');

	}, function() {

		st(this).parent().removeClass('cutted-opened').addClass('cutted-closed');

	});


	/*-------------------------------------------
		5.3 - Owl slider (sticky)
	-------------------------------------------*/

	var owlSticky = st('#owl-sticky');

	if ( !!st.prototype.owlCarousel ) { // Does the owlCarousel exist?

		st(owlSticky).owlCarousel({
	
			autoPlay: st('#owl-sticky').hasClass('autoplay-on') ? true : false,
			stopOnHover: true,
			slideSpeed: 700,
			pagination: false,
			paginationNumbers: false,
			itemsCustom: [
				[0, 1],
				[574, 1],
				[943, 1],
				[1822, 1],
				[2446, 1]
			],
			/*jshint unused: false */
			afterInit: function(speed) {
	
				var
					base = this;
	
					// Set initial bg img
					if ( typeof stStickyBg !== 'undefined' && stStickyBg[base.currentItem] !== 'none' ) {
						st('#header').addClass('header-bg').css({ 'background-image': 'url(' + stStickyBg[base.currentItem] + ')' }); }
	
			},
			afterAction: function(speed) {
	
				var
					base = this,
					prev = '#owl-sticky-nav .prev',
					next = '#owl-sticky-nav .next',
					current = '#owl-sticky-cat';


	
					if ( st('#owl-sticky-cat').length ) {
						st(current).html( '<a href="' + stStickyUrl[base.currentItem] + '">' + stStickyCat[base.currentItem] + '</a>' ); }
	
					if ( st('#owl-sticky-nav').length ) {
	
						st(next).html( stStickyCat[base.currentItem === base.maximumItem ? 0 : base.currentItem + 1] );
						st(prev).html( stStickyCat[base.currentItem === 0 ? base.maximumItem : base.currentItem - 1] );
	
					}
	
					// Set current bg img
					if ( typeof stStickyBg !== 'undefined' ) {
						if (stStickyBg[base.currentItem] !== 'none' ) {
							st('#header').addClass('header-bg').css({ 'background-image': 'url(' + stStickyBg[base.currentItem] + ')' }); }
						else {
							st('#header').removeClass('header-bg').css({ 'background-image': 'url()' }); }
					}
	
			},
			/*jshint unused: true */
			responsiveBaseWidth: '#layout',
		});
	
		st('#owl-sticky-nav .next').click( function(){
			owlSticky.trigger( 'owl.next' );
		});
	
		st('#owl-sticky-nav .prev').click( function(){
			owlSticky.trigger( 'owl.prev' );
		});

	}

	/* For demo */
	st('#stBoxed').on( 'click tap', function(){ st(owlSticky).data('owlCarousel').reinit({ responsiveBaseWidth: '#layout' }); });


	/*-------------------------------------------
		5.4 - Owl slider (most viewed)
	-------------------------------------------*/

	var owlMostViewed = st('#owl-most-viewed');

	if ( !!st.prototype.owlCarousel ) { // Does the owlCarousel exist?

		st(owlMostViewed).owlCarousel({
	
			//autoPlay: true, // true or false or integrer
			stopOnHover: true,
			slideSpeed: 300,
			pagination: false,
			itemsCustom: [
				[0, 1],
				[640, 1],
				[943, 2],
				[1199, 2]
			],
			/*jshint unused: false */
			afterMove: function(speed) {
			},
			/*jshint unused: true */
			responsiveBaseWidth: '#layout',
	
		});
	
		st('#owl-most-viewed-nav .next').click( function(){
			owlMostViewed.trigger( 'owl.next' );
		});
	
		st('#owl-most-viewed-nav .prev').click( function(){
			owlMostViewed.trigger( 'owl.prev' );
		});

	}

	/* For demo */
	st('#stBoxed').on( 'click tap', function(){ st(owlMostViewed).data('owlCarousel').reinit({ responsiveBaseWidth: '#layout' }); });


	/*-------------------------------------------
		5.5 - Responsive top bar: Logo
	-------------------------------------------*/

	st('#resp-top-panel').append( st('#logo > div > div').html() );


	/*-------------------------------------------
		5.6 - Responsive top bar: On\Off
	-------------------------------------------*/

	setInterval( function(){

		if ( sessionStorage.getItem('st_content_holder_width') < 935 && !st('body').hasClass('menu-resp-on') ) {

			var
				scrollCurrent = st(window).scrollTop(),
				scrollPrevious = sessionStorage.getItem('st_window_scroll');

				if ( scrollCurrent > scrollPrevious && scrollPrevious > 0 ) {
					st('#resp-top-panel').addClass('resp-top-panel-off'); }

				if ( scrollCurrent < scrollPrevious ) {
					st('#resp-top-panel').removeClass('resp-top-panel-off'); }

		}

	}, 301 );


	/*-------------------------------------------
		5.7 - Sticked menu
	-------------------------------------------*/

	function st_set_menu_height() {
		st('#menu').css( 'height', st('#menu-box').height() - 1 );
	}

	if ( st('#menu').length && !st('#menu').hasClass('no-sticky-menu') ) {

		// Set initial height of wrapper
		st_set_menu_height();
		st(window).resize( st_set_menu_height );

		var
			st_adminBarHeight = st('body').hasClass('admin-bar') ? 32 : 0;

			setInterval( function(){
		
				if ( sessionStorage.getItem('st_content_holder_width') > 934 ) {

					var
						scrollCurrent = st(window).scrollTop(),
						scrollPrevious = sessionStorage.getItem('st_window_scroll'),
						offset = sessionStorage.getItem('st_menu_offset'),
						height = sessionStorage.getItem('st_menu_height');

						// Stick
						if ( ( scrollCurrent > 1 * offset + height * 3 ) && ( sessionStorage.getItem('st_menu_sticked_status') === 'unsticked' || sessionStorage.getItem('st_menu_sticked_status') === null ) ) {
							st('#menu').addClass('menu-fixed');
							st('#menu-box').addClass('menu-box-fixed none').css( 'transform', 'translate(0,-' + height + 'px)' );
							setTimeout( function(){ st('#menu-box').removeClass('none'); }, 300 );
							sessionStorage.setItem( 'st_menu_sticked_status', 'sticked' );
							sessionStorage.setItem( 'st_menu_status', 'hidden' );
						}
	
						// Unstick
						if ( ( scrollCurrent < 1 * offset - st_adminBarHeight ) && ( sessionStorage.getItem('st_menu_sticked_status') === 'sticked' ) ) {
							st('#menu').removeClass('menu-fixed');
							st('#menu-box').removeClass('menu-box-fixed none').css( 'transform', 'translate(0,0)' );
							sessionStorage.setItem( 'st_menu_sticked_status', 'unsticked' );
							sessionStorage.setItem( 'st_menu_status', 'visible' );
						}

						// Show
						if ( ( scrollCurrent < scrollPrevious && scrollCurrent > 3 * offset ) && ( sessionStorage.getItem('st_menu_status') === 'hidden' ) ) {
							st('#menu').addClass('menu-fixed');
							st('#menu-box').removeClass('none').addClass('menu-box-fixed').css( 'transform', 'translate(0,0)' );
							sessionStorage.setItem( 'st_menu_status', 'visible' );
						}
	
						// Hide
						if ( ( scrollCurrent > scrollPrevious && scrollCurrent > 1 * offset + 3 * height ) && ( sessionStorage.getItem('st_menu_status') === 'visible' ) ) {
							st('#menu-box').css( 'transform', 'translate(0,-' + height + 'px)' );
							sessionStorage.setItem( 'st_menu_status', 'hidden' );
						}
	
				}

			}, 100 );

		// Set menu heigh
		setInterval( function(){ sessionStorage.setItem( 'st_menu_height', st('#menu-box').height() ); }, 1850 );

		// Set menu offset
		setInterval( function(){ sessionStorage.setItem( 'st_menu_offset', Math.floor( st('#menu').offset().top ) ); }, 1900 );

	}


	/*-------------------------------------------
		5.8 - Page transition
	-------------------------------------------*/

	st('#layout').removeClass('opacity-0');



/*==6.===========================================

 	C O M M O N
	Common scripts

===============================================*/

	/*-------------------------------------------
		6.1 - Detect browser name
	-------------------------------------------*/

	function st_browser(){

		var label = navigator.userAgent.match(/(opera|chrome|safari|firefox(?=\/))\/?\s*(\d+)/i) || [];

		if ( label[1] ) {

			st('body')

				.removeClass('opera chrome safari gecko') // Flush classes due page cache

				.addClass( label[1] === 'Firefox' ? 'gecko' : label[1].toLowerCase() );

		}

	}

	st_browser();


	/*-------------------------------------------
		6.2 - Holder for dinamic styles
	-------------------------------------------*/

	if ( !st('#st-dynamic-css').length ) {

		st('head').append('<style id="st-dynamic-css" type="text/css"></style>');

	}


	/*-------------------------------------------
		6.3 - Quick reply form
	-------------------------------------------*/

		/*- 6.3.1 - Open form
		-------------------------------------------*/
	
		st('a.quick-reply').click(function(){

	
			/*--- First of all -----------------------------*/
	
			// Make previous Reply link visible
			st('.quick-reply').removeClass('none');
	
			// Make previous Cancel Reply link hidden
			st('.quick-reply-cancel').addClass('none');
	
			// Erase all quick holders
			st('.quick-holder').html('');
	
			// Make comment form visible
			st('#commentform').removeClass('none');
	
	
			/*--- Append new form -----------------------------*/
	
			var
				id = st(this).attr('title'),
				form = st('#respond').html();
	
				// Make this Reply link hidden
				st(this).addClass('none');
	
				// Make this Cancel Reply link visible
				st(this).next().removeClass('none');
	
				// Put the form to the holder
				st('#quick-holder-' + id).append(form).find('h3').remove();
	
				// Set an ID for hidden field
				st('#quick-holder-' + id + ' input[name="comment_parent"]').val(id);
	
				// Fix placeholders for IE8,9
				if ( st('body').hasClass('ie8') || st('body').hasClass('ie9') ) {
					
					st('.input-text-box input[type="text"], .input-text-box input[type="email"], .input-text-box input[type="url"]', '#quick-holder-' + id).each( function(){ st(this).val( st(this).attr('placeholder') ); } );
	
				}

			// Re-define position of sticky bar
			//st_sticky( true );
	
			return false;
	
		});


		/*- 6.3.2 - Cancel reply
		-------------------------------------------*/
	
		st('.quick-reply-cancel').click(function(){
	
			// Make previous Reply link visible
			st('.quick-reply').removeClass('none');
	
			// Make this Cancel Reply link hidden
			st(this).addClass('none');
	
			// Erase all quick holders
			st('.quick-holder').html('');

			// Re-define position of sticky bar
			//st_sticky( true );

			return false;
	
		});


	/*-------------------------------------------
		6.4 - Textarea animation by focus
	-------------------------------------------*/

	st('#layout').on('focus', 'textarea', function() {

		if ( !st(this).is('#whats-new') && st(this).height() < 151 && ! st(this).hasClass( 'height-ready' ) ) {

			st(this)
				.css({ height: 70 })
				.animate({ height: 150 }, 300, function(){ st(this).addClass( 'height-ready' ); });

		}

	});


	/*-------------------------------------------
		6.5 - Tag cloud
	-------------------------------------------*/

	st('.tagcloud a').each(function(){

		var
			number = st(this).attr('title').split(' ');

			number = '<span>' + number[0] + '</span>';

			st(this).append(number).attr('title','');

	});


	/*-------------------------------------------
		6.6 - Archives widget span
	-------------------------------------------*/

	st('.widget_archive li, .widget_categories li, .product-categories li').each(function(){

		var
			str = st(this).html();

			str = str.replace(/\(/g,"<span>");
			str = str.replace(/\)/g,"</span>");
			
			st(this).html(str);

	});


	/*-------------------------------------------
		6.7 - Image original side
	-------------------------------------------*/

	st('.size-original').removeAttr('width').removeAttr('height');


	/*-------------------------------------------
		6.8 - Max size for YouTube & Vimeo video
	-------------------------------------------*/

	function st_video_resize(){

		st('iframe').each(function(){

			var
				src = st(this).attr('src');

				if ( src ) {

					var
						check_youtube = src.split('youtube.com'),
						check_vimeo = src.split('vimeo.com'),
						check_ted = src.split('ted.com'),
						check_ustream = src.split('ustream.tv'),
						check_metacafe = src.split('metacafe.com'),
						check_rutube = src.split('rutube.ru'),
						check_mailru = src.split('video.mail.ru'),
						check_vk = src.split('vk.com'),
						check_yandex = src.split('video.yandex'),
						check_dailymotion = src.split('dailymotion.com');
		
						if (
							check_youtube[1] ||
							check_vimeo[1] ||
							check_ted[1] ||
							check_ustream[1] ||
							check_metacafe[1] ||
							check_rutube[1] ||
							check_mailru[1] ||
							check_vk[1] ||
							check_yandex[1] ||
							check_dailymotion[1]
							) {
		
								var
									parentWidth = st(this).parent().width(),
									w = st(this).attr('width') ? st(this).attr('width') : 0,
									h = st(this).attr('height') ? st(this).attr('height') : 0,
									ratio = h / w,
									height = parentWidth * ratio;
			
									if ( w > 1 ) {
										st(this).css({ 'width': parentWidth, 'height': height }); }
		
						}

				}

		});

	}

	setTimeout( st_video_resize, 500 );

	st(window).resize( st_video_resize );

	// BuddyPress
	if ( st('#buddypress').length ) {
		setInterval( st_video_resize, 3333 ); }


	/*-------------------------------------------
		6.9 - ST Gallery script
	-------------------------------------------*/

	/* none */


	/*-------------------------------------------
		6.10 - Search form on header
	-------------------------------------------*/

	st('.search-form-holder-button').click(function(){
		st('#search-form-holder').addClass('search-form-holder-on').find('input').focus();
	});

	st('#search-form-holder span').click(function(){
		st('#search-form-holder').removeClass('search-form-holder-on');
	});


	/*-------------------------------------------
		6.11 - BuddyPress fixes
	-------------------------------------------*/

	st('body.group-create h1.page-title a').addClass('button').addClass('bp-title-button');


	/*-------------------------------------------
		6.12 - IE fixes
	-------------------------------------------*/

	/*
	
		6.12.1 - Quick reply form
		6.12.2 - OnBlur/OnFocus for input fields
		6.12.3 - Dummy Search
		6.12.4 - Dummy Subscribe
	
	*/

	if ( st('#ie9-detect').length ) { st('body').addClass('ie9'); }

	if ( st('body').hasClass('ie8') || st('body').hasClass('ie9') ) {
	

		/*- 6.12.1 - Append and remove quick form
		===========================================*/
	
		/*
		
			6.12.1 - QUICK REPLY FORM
		
				6.12.1.1 - Remove dummy before submiting
				6.12.1.2 - Return dummy after unsuccess submiting
		
		*/
	
			/*- 6.12.1.1 - Remove a dummy before submitting
			-------------------------------------------*/
		
			st('#layout')
		
				.on('mousedown tap', '.form-submit input[type="submit"]', function(){
		
					st(this).parent().parent().find('input[type="text"]')
						.each(function(){
		
							var
								dummy = st(this).attr('placeholder'),
								val = st(this).val();
				
								if ( dummy === val ) {
									st(this).val(''); }
		
						});
		
				});
		
		
			/*- 6.12.1.2 - Return a dummy after unsuccess submitting
			-------------------------------------------*/
		
			st('body').on('ready mouseenter tap', '#layout', function(){
		
				st('input[type="text"]',this).each(function(){
		
					var
						dummy = st(this).attr('placeholder'),
						val = st(this).val();
		
						if ( !val ) {
							st(this).val(dummy); }
		
				});
		
			});
	
	
		/*- 6.12.2 - For input fields
		===========================================*/
	
		st('#layout')
	
			.on('focus', 'input[type="text"]', function(){
	
				var
					dummy = st(this).attr('placeholder'),
					val = st(this).val();
	
					if ( dummy === val ) {
						st(this).val(''); }
	
				})
	
			.on('blur', 'input[type="text"]', function(){
	
				var
					dummy = st(this).attr('placeholder'),
					val = st(this).val();
	
					if ( !val ) {
						st(this).val(dummy); }
	
				});
	
	
		/*- 6.12.3 - Dummy data for search input field
		===========================================*/
	
		st('.searchform').each(function(){
	
			var
				dummy = st('input[type="submit"]',this).val();
	
				st('input[name="s"]',this).val(dummy).attr('placeholder', dummy);
	
		});
	
	
		/*- 6.12.4 - Dummy data for subscribe form
		===========================================*/
	
		st('.feedemail-input').each(function(){
	
			var
				dummy = st(this).attr('placeholder');
	
				st(this).val(dummy);
	
		});


	} // if ( st('body').hasClass('ie8') || st('body').hasClass('ie9') )


	/*-------------------------------------------
		6.13 - WooCommerce
	-------------------------------------------*/

	/*
	
		6.13.1 - Re-build thumbnail
		6.13.2 - Add class to Read More button
		6.13.3 - Remove the First class
		6.13.4 - Replace upsell products
		6.13.5 - Replace related products
		6.13.6 - Replace crosssell products
	
	*/

	if ( st('div').hasClass('woocommerce') || st('body').hasClass('woocommerce-page') ) {
	
	
		/*- 6.13.1 - Re-build thumbnail
		-------------------------------------------*/
	
		st('ul.products > li > a:first-child').each(function(){
	
			var
				sale = st('.onsale',this).length ? st('.onsale',this)[0].outerHTML : '',
				img = st('img',this).length ? st('img',this)[0].outerHTML : '',
				title = st('h3',this).length ? st('h3',this)[0].innerHTML : '',
				rating = st('.star-rating',this).length ? st('.star-rating',this)[0].outerHTML : '',
				price = st('.price',this).length ? st('.price',this)[0].outerHTML : '';
	
				// Replace everything
				st(this).html( '<div class="div-as-table st-woo-hover"><div><div><h3>' + title + ' ' + sale + '</h3></div></div></div>' + img + rating );
	
				// Replace a price
				st(this).parent().append( '<div class="div-as-table st-woo-price"><div><div>' + price + '</div></div></div>' );
	
				// Add class when it ready be shown
				st(this).parent().addClass('st-woo');
	
		});


		/*- 6.13.2 - Add class to Read More button
		-------------------------------------------*/
	
		st('a.add_to_cart_button').each(function(){
	
			var
				check = st(this).attr('href');
	
				check = check.split('?add-to-cart=');
	
				if ( check[1] === undefined ) {
					st(this).addClass('read_more_button'); }
	
		});


		/*- 6.13.3 - Remove the First class
		-------------------------------------------*/
	
		st('.woocommerce .product .thumbnails a').each(function(){
	
			st(this).removeClass('first').removeClass('last');
	
		});


		/*- 6.13.4 - Replace upsell products
		-------------------------------------------*/
	
		st('.woocommerce .product .upsells').each(function(){
	
			st('li.last',this).removeClass('last');
			st('li.first',this).removeClass('first');
	
			var
				related = st(this).html();
	
				st(this).parent().parent().append( '<div class="st-woo-upsells">' + related + '<div class="clear"></div></div>' );
	
				st(this).remove();

		});


		/*- 6.13.5 - Replace related products
		-------------------------------------------*/
	
		st('.woocommerce .product .related').each(function(){
	
			st('li.last',this).removeClass('last');
			st('li.first',this).removeClass('first');
	
			var
				related = st(this).html();
	
				st(this).parent().parent().append( '<div class="st-woo-related">' + related + '<div class="clear"></div></div>' );
	
				st(this).remove();
	
		});


		/*- 6.13.6 - Replace crosssell products
		-------------------------------------------*/
	
		st('.woocommerce .cross-sells').each(function(){
	
			var
				cross = st(this).html();
	
				st(this).html( '<div class="st-woo-cross">' + cross + '<div class="clear"></div></div>' );
	
				//st(this).remove();
	
		});
	
	
	} // if ( st('body').hasClass('woocommerce') )


	/*-------------------------------------------
		6.14 - Webkit fixes
	-------------------------------------------*/

	/*st('body.chrome select, body.safari select').each(function(){

		var
			tag = st(this).parent().prop('tagName');

			if ( tag !== 'LABEL' ) {

				st(this).wrap('<label class="st-select-label"></label>');

			}

	});*/


	/*-------------------------------------------
		6.15 - Comment tabs
	-------------------------------------------*/

	st('#tabs-comments span').click( function(){

		if ( !st(this).hasClass('tab-comments-active') ) {

			st('#tabs-comments span.tab-comments-active').removeClass('tab-comments-active');
			st(this).addClass('tab-comments-active');

			if ( st(this).data('label') === 'respond' ) {

				st('#respond').removeClass('none');
				st('#comments').addClass('none');

			}

			else {

				st('#respond').addClass('none');
				st('#comments').removeClass('none');

			}


		}

		// Re-define sticky bar
		//st_sticky( true );
	
	});

	// Open comments by loading
	if ( st('#tabs-comments').length ) {

		var
			st_href = window.location.href.split("#comment");
	
			if ( st_href.length && st_href[1] ) {
	
				st('#tabs-comments span.tab-comments-active').removeClass('tab-comments-active').next().addClass('tab-comments-active');
	
				st('#respond').addClass('none');
				st('#comments').removeClass('none');
	
				// Re-define sticky bar
				//st_sticky( true );
	
			}

	}


/*==7.===========================================

	S E S S I O N S   &   I N T E R V A L S
	Vary common data

===============================================*/

	/*-------------------------------------------
		7.1 - Set content holder width
	-------------------------------------------*/

	setInterval( function(){ sessionStorage.setItem( 'st_content_holder_width', st('#content-holder').width() ); }, 1650 );


	/*-------------------------------------------
		7.2 - Set current scroll
	-------------------------------------------*/

	setInterval( function(){ sessionStorage.setItem( 'st_window_scroll', st(window).scrollTop() ); }, 301 );


});



/*==8.===========================================

	A C T I O N S   B Y   L O A D I N G
	Starts after complete loading

===============================================*/

var pl = jQuery.noConflict();

jQuery(document).ready(function() {

	/*-------------------------------------------
		8.1 - Flickr widget 150px thumbnails
	-------------------------------------------*/

	pl('.flickr_badge_image img')

		.attr({

			src: function() {

				return pl(this).attr('src').replace('_s.jpg','_q.jpg');

			}
			
		})

		.removeAttr('width height');


	/*-------------------------------------------
		8.2 - Scroll to top button
	-------------------------------------------*/

	pl('body').append('<div id="scroll-to-top"><!-- Scroll to top --></div>');

	pl('#scroll-to-top').on('click', function(){ pl('html, body').animate({ scrollTop: 0 }, 1000 ); return false; });

	setInterval(function() {

		if ( sessionStorage.getItem( 'st_window_scroll' ) > 1000 ) {
			pl('#scroll-to-top').addClass('scroll-to-top-on'); }

		else {
			pl('#scroll-to-top').removeClass('scroll-to-top-on'); }

	}, 1970 );


	/*-------------------------------------------
		8.3 - Keep content within box because of Chrome bug
	-------------------------------------------*/

	function st_content_chrome_fix() {
		pl('#content-box').css({ 'width': '65%', 'position': 'relative' });
		setTimeout( function() { pl('#content-box').css({ 'width': '', 'position': '' }); }, 10 );
	}
	st_content_chrome_fix();


});



	/*-------------------------------------------
		8.4 - Sticked sidebars
	-------------------------------------------*/

	(function(pl) {
		pl.fn.st_sticky = function( now ) {
			return this.each(function( now ) {

					var sticky = {};
	
					sticky.master = pl(this).attr('data-master');
					sticky.id = 'st-sticky-' + Math.floor( ( Math.random() * 1000 ) + 1 );
					sticky.adminbar = pl('#wpadminbar').length ? pl('#wpadminbar').height() : 0;
	
				if ( Math.ceil( pl('#' + sticky.master).height() ) < Math.ceil( pl('#' + sticky.id).children().height() ) ) {
					pl('#' + sticky.id).children().css({ 'position': '', 'top': 'auto', 'bottom': 'auto' });
					return;
				}
	
				// Apply ID
				pl(this).attr( 'id', sticky.id );
	
				// Set initial vars
				sessionStorage.setItem( sticky.id, JSON.stringify( sticky ) );
	
				// Set default status
				sessionStorage.setItem( sticky.id + '-status', 'default' );
	
				function st_sticky_do( args ) {

					var
						sticky = JSON.parse( sessionStorage.getItem( args.id ) );
						//scrollCurrent = sessionStorage.getItem( 'st_window_scroll' );
						

					if ( window.outerWidth < 960 ) {

						if ( sessionStorage.getItem( sticky.id + '-status' ) !== 'default' ) {
							pl('#' + sticky.id).css({ 'height': '' });
							pl('#' + sticky.id).children().css({ 'position': '', 'top': 'auto', 'bottom': 'auto' });
							sessionStorage.setItem( sticky.id + '-status', 'default' );
						}

						return;

					}

					var scrollCurrent = pl(window).scrollTop();

					// Now || Init & re-init
					if ( args.now === true || args.init === true ) {
	
						now = false;

						// Reset height
						//pl('#' + sticky.id).css( 'height', '' );
						pl('#' + sticky.master).css( 'height', '' );
	
						if ( args.init !== true ) {
	
							// Reset sidebar position
							pl('#' + sticky.id).children().css({ 'position': 'relative', 'top': '' });
	
						}
	
						// Padding
						sticky.padding = pl('#' + sticky.master).css('paddingTop').replace('px', '');
	
						// Sticky height
						sticky.height = Math.ceil( pl('#' + sticky.id).children().height() );
			
						// Master height
						sticky.master_height = Math.ceil( pl('#' + sticky.master).height() );
			
						// Master top
						sticky.master_top = pl('#' + sticky.master).offset().top;
			
						// Master bottom
						sticky.master_bottom = sticky.master_height * 1 + sticky.master_top * 1;
	
						// Set height to sticky holder
						if ( sticky.height < sticky.master_height && pl('#' + sticky.id).height() !== sticky.master_height ) {
							pl('#' + sticky.id).css( 'height', sticky.master_height );
						}
						if ( sticky.height > sticky.master_height ) {
							if ( sessionStorage.getItem( sticky.id + '-status' ) !== 'default' ) {


								pl('#' + sticky.id).removeAttr('style').children().removeAttr('style');
								sessionStorage.setItem( sticky.id + '-status', 'default' );
							}
						}

						// Save session
						sessionStorage.setItem( sticky.id, JSON.stringify( sticky ) );
	
						// Return
						if ( args.init === true ) {
							return; }
	
					}
	
					// Check if content area is higher than sidebar
					if ( sticky.master_height - sticky.height > 50 ) {
	
						/*--- by default -----------------------------*/
		
						if ( sticky.master_top > scrollCurrent * 1 + sticky.adminbar * 1 ) {
	
							if ( sessionStorage.getItem( sticky.id + '-status' ) !== 'default' ) {
	
								pl('#' + sticky.id).children().css({ 'position': '', 'top': 'auto', 'bottom': 'auto' });
								sessionStorage.setItem( sticky.id + '-status', 'default' );
								//console.log( sessionStorage.getItem( sticky.id + '-status' ) );
								/*console.log(
									'default: if ( sticky.master_top > scrollCurrent + sticky.adminbar ) ' + sticky.master_top + ' > ' + (scrollCurrent * 1 + sticky.adminbar * 1)
								);*/
	
							}
	
						}
		
						/*--- by top -----------------------------*/
		
						else {
		
							if ( sticky.master_top < scrollCurrent * 1 + sticky.adminbar * 1 && sticky.master_bottom > scrollCurrent * 1 + sticky.height * 1 ) {
			
								if ( sessionStorage.getItem( sticky.id + '-status' ) !== 'top' ) {
			
									pl('#' + sticky.id).children().css({ 'position': 'fixed', 'top': sticky.padding * 1 + sticky.adminbar * 1, 'bottom': 'auto' });
									sessionStorage.setItem( sticky.id + '-status', 'top' );
									//console.log( sessionStorage.getItem( sticky.id + '-status' ) );
									/*console.log(
										'top: if ( sticky.master_top < scrollCurrent + sticky.adminbar ) ' + sticky.master_top + ' < ' + (scrollCurrent * 1 + sticky.adminbar * 1)
									);
									console.log(
										'top: if ( sticky.master_bottom > scrollCurrent + sticky.height + ) ' + sticky.master_bottom + ' > ' + (scrollCurrent * 1 + sticky.height * 1 )
									);*/
	
								}
			
							}
		
						}
	
						/*--- by bottom -----------------------------*/
		
						if ( sticky.master_bottom < scrollCurrent * 1 + sticky.height * 1  ) {
	
							if ( sessionStorage.getItem( sticky.id + '-status' ) !== 'bottom' ) {
	
								pl('#' + sticky.id).children().css({ 'position': 'absolute', 'top': 'auto', 'bottom': '0' });
								sessionStorage.setItem( sticky.id + '-status', 'bottom' );
								//console.log( sessionStorage.getItem( sticky.id + '-status' ) );
								/*console.log(
									'bottom: if ( sticky.master_bottom < scrollCurrent + sticky.height ) ' + sticky.master_bottom + ' < ' + ( scrollCurrent * 1 + sticky.height * 1 )
								);*/
	
							}
		
						}
		
					}
	
				}
	
				// Call by initial request + by third-party requests
				if ( now === true ) {
					var args = {};
						args.now = true;
						args.id = sticky.id;
					st_sticky_do( args );
				}
	
				// Major call
				setInterval( function() {
					var args = {};
						args.id = sticky.id;
					st_sticky_do( args );
				}, 100 );
	
				// Re-init
				setInterval( function() {
					var args = {};
						args.id = sticky.id;
						args.init = true;
					st_sticky_do( args );
				}, 350 );
	
				// Reset the sticky because of bug in case fast scrolling to top
				/*setInterval( function(){
					sticky.master_top = pl('#' + sticky.master).offset().top; // Because of underfined
					if ( sticky.master_top > sessionStorage.getItem( 'st_window_scroll' ) * 1 + sticky.adminbar * 1 ) {
						pl('#' + sticky.id).children().css({ 'position': '', 'top': 'auto', 'bottom': 'auto' });
					}
				}, 450);*/

			});
		};
	})(jQuery);

	pl('.st-sticky').st_sticky( true );



/*==9.===========================================

	J A V A   S C R I P T
	Pure JS

===============================================*/

	/*-------------------------------------------
		9.1 - For IE only
	-------------------------------------------*/

	var
		ie8check = document.getElementById('ie8-detect');

		if ( ie8check !== null && ie8check.value === undefined ) {
			st('body').addClass('ie8');	}



